/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.util.Iterables2;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.ReferenceType;

@Singleton
public class CatalogItemsInCatalog
implements Function<Catalog, Iterable<CatalogItem>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    CatalogItemsInCatalog(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    @Override
    public Iterable<CatalogItem> apply(Catalog from) {
        Iterable<? extends CatalogItem> catalogItems = FutureIterables.transformParallel(Iterables.filter(from.values(), new Predicate<ReferenceType>(){

            @Override
            public boolean apply(ReferenceType input) {
                return input.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml");
            }
        }), new Function<ReferenceType, Future<? extends CatalogItem>>(){

            @Override
            public Future<CatalogItem> apply(ReferenceType from) {
                return CatalogItemsInCatalog.this.aclient.getCatalogClient().getCatalogItem(from.getHref());
            }
        }, this.executor, null, this.logger, "catalogItems in " + from.getHref());
        return Iterables2.concreteCopy(catalogItems);
    }
}

