/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.ovf.Network;
import org.jclouds.vcloud.domain.VAppTemplate;

@Singleton
public class DefaultNetworkNameInTemplate
implements Function<VAppTemplate, String> {
    @Resource
    protected Logger logger = Logger.NULL;

    @Override
    public String apply(VAppTemplate vAppTemplate) {
        Preconditions.checkArgument(vAppTemplate != null, "vAppTemplate was null!");
        Set<Network> networks = vAppTemplate.getNetworkSection().getNetworks();
        Preconditions.checkArgument(networks.size() > 0, "no networks found in vAppTemplate %s", vAppTemplate);
        if (networks.size() > 1) {
            this.logger.warn("multiple networks found for %s, choosing first from: %s", vAppTemplate.getName(), networks);
        }
        return Iterables.get(networks, 0).getName();
    }
}

