/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.util.Iterables2;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.network.OrgNetwork;

@Singleton
public class NetworksInOrg
implements Function<Org, Iterable<OrgNetwork>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    NetworksInOrg(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    @Override
    public Iterable<OrgNetwork> apply(Org org) {
        Iterable<? extends OrgNetwork> networkItems = FutureIterables.transformParallel(org.getNetworks().values(), new Function<ReferenceType, Future<? extends OrgNetwork>>(){

            @Override
            public Future<? extends OrgNetwork> apply(ReferenceType from) {
                return NetworksInOrg.this.aclient.getNetworkClient().getNetwork(from.getHref());
            }
        }, this.executor, null, this.logger, "OrgNetworks in org " + org.getName());
        return Iterables2.concreteCopy(networkItems);
    }
}

