/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.Org;

@Singleton
public class OrgsForNames
implements Function<Iterable<String>, Iterable<Org>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    OrgsForNames(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    @Override
    public Iterable<Org> apply(Iterable<String> from) {
        return Iterables.filter(FutureIterables.transformParallel(from, new Function<String, Future<? extends Org>>(){

            @Override
            public Future<Org> apply(String from) {
                return OrgsForNames.this.aclient.getOrgClient().findOrgNamed(from);
            }
        }, this.executor, null, this.logger, "organizations for names"), Predicates.notNull());
    }
}

