/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ovf.VirtualHardwareSection;
import org.jclouds.ovf.xml.VirtualHardwareSectionHandler;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.ovf.VCloudVirtualHardwareSection;
import org.jclouds.vcloud.util.Utils;
import org.xml.sax.Attributes;

public class VCloudVirtualHardwareHandler
extends ParseSax.HandlerWithResult<VCloudVirtualHardwareSection> {
    private final VirtualHardwareSectionHandler hardwareHandler;
    private ReferenceType hardware;

    @Inject
    public VCloudVirtualHardwareHandler(VirtualHardwareSectionHandler hardwareHandler) {
        this.hardwareHandler = hardwareHandler;
    }

    @Override
    public VCloudVirtualHardwareSection getResult() {
        VirtualHardwareSection hardware = (VirtualHardwareSection)this.hardwareHandler.getResult();
        return new VCloudVirtualHardwareSection(this.hardware.getType(), this.hardware.getHref(), hardware.getInfo(), hardware.getTransports(), hardware.getSystem(), hardware.getItems());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.endsWith("VirtualHardwareSection")) {
            this.hardware = Utils.newReferenceType(attributes);
        }
        this.hardwareHandler.startElement(uri, localName, qName, attrs);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.hardwareHandler.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.hardwareHandler.characters(ch, start, length);
    }
}

