/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.variables;

import java.util.Map;
import org.nnsoft.guice.rocoto.variables.Appender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class KeyAppender
implements Appender {
    private final String key;
    private final String defaultValue;

    public KeyAppender(String key) {
        this(key, null);
    }

    public KeyAppender(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Override
    public void append(StringBuilder buffer, Map<String, String> configuration) {
        String value = configuration.get(this.key);
        if (value != null) {
            buffer.append(value);
        } else if (this.defaultValue != null) {
            buffer.append(this.defaultValue);
        } else {
            buffer.append("${").append(this.key).append('}');
        }
    }

    public String toString() {
        return "${" + this.key + "}";
    }
}

