/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.amqp.generator;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.generator.Generator;
import org.fusesource.amqp.generator.Log;
import org.fusesource.amqp.generator.Utilities;
import org.fusesource.amqp.generator.jaxb.Type;
import org.fusesource.hawtbuf.Buffer;

public abstract class AmqpDefinedType {
    protected JCodeModel cm;
    protected Generator generator;
    protected Type type;
    protected JDefinedClass definedClass;
    protected JMethod write;
    protected JMethod writeConstructor;
    protected JMethod writeBody;
    protected JMethod read;
    protected JMethod encodeTo;
    protected JMethod decodeFrom;
    protected JMethod getArrayConstructor;
    protected JMethod size;
    protected JMethod sizeOfConstructor;
    protected JMethod sizeOfBody;

    public AmqpDefinedType(Generator generator, String className, Type type) throws JClassAlreadyExistsException {
        Log.info("Creating new class %s for type %s", className, type.getName());
        this.cm = generator.getCm();
        this.generator = generator;
        this.type = type;
        this.definedClass = this.cm._class(className);
        this.init();
    }

    protected void init() {
        if (this.type.getProvides() != null) {
            String[] types;
            for (String t : types = this.type.getProvides().split(",")) {
                this.cls()._implements(this.cm.ref(this.generator.getInterfaces() + ".AMQP" + Utilities.toJavaClassName(t)));
            }
        } else {
            this.cls()._implements(this.cm.ref(this.generator.getAmqpBaseType()));
        }
        this.createInitialFields();
        this.createStaticBlock();
        this.createGetArrayConstructor();
        this.generator.registry().cls().init().add((JStatement)JExpr._new((JClass)this.cls()));
    }

    protected abstract void createGetArrayConstructor();

    protected abstract void createStaticBlock();

    protected abstract void createInitialFields();

    public JMethod size() {
        if (this.size == null) {
            this.size = this.cls().method(1, (JType)this.cm.LONG, "size");
        }
        return this.size;
    }

    public JMethod writeConstructor() {
        if (this.writeConstructor == null) {
            this.writeConstructor = this.cls().method(1, (JType)this.cm.BYTE, "writeConstructor");
            this.writeConstructor._throws(Exception.class);
            this.writeConstructor.param(DataOutput.class, "out");
        }
        return this.writeConstructor;
    }

    public JMethod writeBody() {
        if (this.writeBody == null) {
            this.writeBody = this.cls().method(1, (JType)this.cm.VOID, "writeBody");
            this.writeBody._throws(Exception.class);
            this.writeBody.param((JType)this.cm.BYTE, "formatCode");
            this.writeBody.param(DataOutput.class, "out");
        }
        return this.writeBody;
    }

    public JMethod sizeOfConstructor() {
        if (this.sizeOfConstructor == null) {
            this.sizeOfConstructor = this.cls().method(1, (JType)this.cm.LONG, "sizeOfConstructor");
        }
        return this.sizeOfConstructor;
    }

    public JMethod sizeOfBody() {
        if (this.sizeOfBody == null) {
            this.sizeOfBody = this.cls().method(1, (JType)this.cm.LONG, "sizeOfBody");
        }
        return this.sizeOfBody;
    }

    public JMethod write() {
        if (this.write == null) {
            this.write = this.cls().method(1, (JType)this.cm.VOID, "write");
            this.write._throws(Exception.class);
            this.write.param(DataOutput.class, "out");
        }
        return this.write;
    }

    public JMethod read() {
        if (this.read == null) {
            this.read = this.cls().method(1, (JType)this.cm.VOID, "read");
            this.read._throws(Exception.class);
            this.read.param((JType)this.cm.BYTE, "formatCode");
            this.read.param(DataInput.class, "in");
        }
        return this.read;
    }

    public JMethod encodeTo() {
        if (this.encodeTo == null) {
            this.encodeTo = this.cls().method(1, (JType)this.cm.VOID, "encodeTo");
            this.encodeTo._throws(Exception.class);
            this.encodeTo.param(Buffer.class, "buffer");
            this.encodeTo.param((JType)this.cm.INT, "offset");
        }
        return this.encodeTo;
    }

    public JMethod decodeFrom() {
        if (this.decodeFrom == null) {
            this.decodeFrom = this.cls().method(1, (JType)this.cm.VOID, "decodeFrom");
            this.decodeFrom._throws(Exception.class);
            this.decodeFrom.param((JType)this.cm.BYTE, "formatCode");
            this.decodeFrom.param(Buffer.class, "buffer");
            this.decodeFrom.param((JType)this.cm.INT, "offset");
        }
        return this.decodeFrom;
    }

    public JDefinedClass cls() {
        return this.definedClass;
    }
}

