/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.amqp.generator;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.fusesource.amqp.generator.Generator;
import org.fusesource.amqp.generator.Log;

public class AmqpGeneratorMojo
extends AbstractMojo {
    protected MavenProject project;
    private File sourceDirectory;
    private File mainSourceDirectory;
    private String typesDescriptor;
    private File mainOutputDirectory;
    private File testSourceDirectory;
    private File testOutputDirectory;
    private String codecPackagePrefix;
    private String typesPackagePrefix;

    public void execute() throws MojoExecutionException {
        Log.LOG = this.getLog();
        Log.info("\tmain source directory at %s", this.mainSourceDirectory);
        Log.info("\tmain output directory at %s", this.mainOutputDirectory);
        Log.info("\ttest source directory at %s", this.testSourceDirectory);
        Log.info("\ttest output directory at %s", this.testOutputDirectory);
        File[] mainFiles = null;
        if (this.mainSourceDirectory.exists()) {
            mainFiles = this.mainSourceDirectory.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".xml");
                }
            });
            if (mainFiles == null || mainFiles.length == 0) {
                Log.warn("No AMQP XML definitions found in directory : %s", this.mainSourceDirectory.getPath());
            } else {
                this.processFiles(mainFiles, this.mainOutputDirectory);
                this.project.addCompileSourceRoot(this.mainOutputDirectory.getAbsolutePath());
            }
        } else {
            Log.warn("Configured main source directory at %s does not exist", this.mainSourceDirectory);
        }
        File[] testFiles = null;
        if (this.testSourceDirectory.exists()) {
            testFiles = this.testSourceDirectory.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".xml");
                }
            });
            if (testFiles == null || testFiles.length == 0) {
                Log.warn("No AMQP XML definitions found in directory : %s", this.testSourceDirectory.getPath());
            } else {
                this.processFiles(testFiles, this.testOutputDirectory);
                this.project.addTestCompileSourceRoot(this.testOutputDirectory.getAbsolutePath());
            }
        } else {
            Log.warn("Configured test source directory at %s does not exist", this.testSourceDirectory);
        }
    }

    private void processFiles(File[] mainFiles, File outputDir) throws MojoExecutionException {
        Log.info("Processing files : ", new Object[0]);
        List<File> recFiles = Arrays.asList(mainFiles);
        for (File file : recFiles) {
            Log.info("\t%s", file);
        }
        try {
            Generator gen = new Generator();
            gen.setInputFiles(mainFiles);
            gen.setOutputDirectory(outputDir);
            gen.setSourceDirectory(this.sourceDirectory);
            gen.setCodecPackagePrefix(this.codecPackagePrefix);
            gen.setTypes(this.typesPackagePrefix);
            gen.generate();
        }
        catch (Exception e) {
            Log.error("Error generating code : " + e + " - " + e.getMessage(), e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

