/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.amqp.generator;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.math.BigInteger;
import java.util.ArrayList;
import org.fusesource.amqp.generator.AmqpDefinedType;
import org.fusesource.amqp.generator.Generator;
import org.fusesource.amqp.generator.Log;
import org.fusesource.amqp.generator.Utilities;
import org.fusesource.amqp.generator.jaxb.Descriptor;
import org.fusesource.amqp.generator.jaxb.Field;
import org.fusesource.amqp.generator.jaxb.Type;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class DescribedType
extends AmqpDefinedType {
    private JFieldVar SYMBOLIC_ID;
    private JFieldVar SYMBOLIC_ID_SIZE;
    private JFieldVar NUMERIC_ID;
    private JFieldVar NUMERIC_ID_SIZE;
    private JFieldVar SYMBOLIC_CONSTRUCTOR;
    private JFieldVar NUMERIC_CONSTRUCTOR;
    private JFieldVar CONSTRUCTOR;
    private JMethod write;
    private JMethod read;
    private JMethod encodeTo;
    private JMethod decodeFrom;
    private JMethod count;
    private JMethod size;
    private ArrayList<Attribute> amqpFields = new ArrayList();

    public DescribedType(Generator generator, String className, Type type) throws JClassAlreadyExistsException {
        super(generator, className, type);
    }

    protected void createGetArrayConstructor() {
        this.getArrayConstructor = this.cls().method(1, (JType)this.cm.ref("Object"), "getArrayConstructor");
        this.getArrayConstructor.body()._return((JExpression)JExpr._new((JClass)this.cm.ref(this.generator.getMarshaller() + ".DescribedConstructor")).arg((JExpression)JExpr.ref((String)"NUMERIC_ID")));
    }

    protected void createInitialFields() {
    }

    protected void createStaticBlock() {
        for (Object obj : this.type.getEncodingOrDescriptorOrFieldOrChoiceOrDoc()) {
            if (!(obj instanceof Descriptor)) continue;
            Descriptor desc = (Descriptor)obj;
            int mods = 25;
            this.SYMBOLIC_ID = this.cls().field(mods, Buffer.class, "SYMBOLIC_ID", (JExpression)JExpr._new((JClass)this.cm.ref(AsciiBuffer.class)).arg(desc.getName()));
            this.SYMBOLIC_ID_SIZE = this.cls().field(mods, Long.class, "SYMBOLIC_ID_SIZE", (JExpression)this.generator.registry().cls().staticInvoke("instance").invoke("sizer").invoke("sizeOfSymbol").arg((JExpression)JExpr.ref((String)"SYMBOLIC_ID")));
            String[] code = desc.getCode().split(":");
            String category = code[0];
            String descriptorId = code[1];
            category = category.substring(2);
            descriptorId = descriptorId.substring(2);
            this.NUMERIC_ID = this.cls().field(mods, BigInteger.class, "NUMERIC_ID", (JExpression)JExpr._new((JClass)this.cm.ref("java.math.BigInteger")).arg(JExpr.lit((String)(category + descriptorId))).arg(JExpr.lit((int)16)));
            this.NUMERIC_ID_SIZE = this.cls().field(mods, Long.class, "NUMERIC_ID_SIZE", (JExpression)this.generator.registry().cls().staticInvoke("instance").invoke("sizer").invoke("sizeOfULong").arg((JExpression)JExpr.ref((String)"NUMERIC_ID")));
            this.SYMBOLIC_CONSTRUCTOR = this.cls().field(mods, (JType)this.cm.ref(this.generator.getMarshaller() + ".DescribedConstructor"), "SYMBOLIC_CONSTRUCTOR", (JExpression)JExpr._new((JClass)this.cm.ref(this.generator.getMarshaller() + ".DescribedConstructor")).arg((JExpression)JExpr.ref((String)"SYMBOLIC_ID")));
            this.NUMERIC_CONSTRUCTOR = this.cls().field(mods, (JType)this.cm.ref(this.generator.getMarshaller() + ".DescribedConstructor"), "NUMERIC_CONSTRUCTOR", (JExpression)JExpr._new((JClass)this.cm.ref(this.generator.getMarshaller() + ".DescribedConstructor")).arg((JExpression)JExpr.ref((String)"NUMERIC_ID")));
            this.CONSTRUCTOR = this.cls().field(mods, (JType)this.cm.ref(this.generator.getMarshaller() + ".DescribedConstructor"), "CONSTRUCTOR");
            this.cls().init().add((JStatement)this.generator.registry().cls().staticInvoke("instance").invoke("getFormatCodeMap").invoke("put").arg((JExpression)JExpr.ref((String)"NUMERIC_ID")).arg(this.cls().dotclass()));
            this.cls().init().add((JStatement)this.generator.registry().cls().staticInvoke("instance").invoke("getSymbolicCodeMap").invoke("put").arg((JExpression)JExpr.ref((String)"SYMBOLIC_ID")).arg(this.cls().dotclass()));
            JConditional block = this.cls().init()._if((JExpression)this.cm.ref("java.lang.Boolean").staticInvoke("parseBoolean").arg((JExpression)this.cm.ref("java.lang.System").staticInvoke("getProperty").arg(JExpr.lit((String)(this.generator.getCodecPackagePrefix() + ".UseSymbolicID")))));
            block._then().assign((JAssignmentTarget)JExpr.ref((String)"CONSTRUCTOR"), (JExpression)JExpr.ref((String)"SYMBOLIC_CONSTRUCTOR"));
            block._else().assign((JAssignmentTarget)JExpr.ref((String)"CONSTRUCTOR"), (JExpression)JExpr.ref((String)"NUMERIC_CONSTRUCTOR"));
        }
    }

    public void generateToString() {
        JMethod toString1 = this.cls().method(1, (JType)this.cm.ref("java.lang.String"), "toString");
        toString1.body()._return((JExpression)JExpr.ref((String)"this").invoke("toString").arg(JExpr.lit((String)"")));
        JMethod toString2 = this.cls().method(1, (JType)this.cm.ref("java.lang.String"), "toString");
        toString2.param(String.class, "indent");
        toString2.body().decl((JType)this.cm.ref("java.lang.String"), "rc", JExpr.lit((String)""));
        for (int i = 0; i < this.amqpFields.size(); ++i) {
            Attribute attr = this.amqpFields.get(i);
            if (attr.attribute.type().isArray()) {
                JBlock block = toString2.body()._if(JExpr._this().ref((JVar)attr.attribute).ne(JExpr._null()))._then().block();
                block._if(JExpr.ref((String)"rc").invoke("length").ne(JExpr.lit((int)0)))._then().assignPlus((JAssignmentTarget)JExpr.ref((String)"rc"), JExpr.lit((String)",\n"));
                block.assignPlus((JAssignmentTarget)JExpr.ref((String)"rc"), JExpr.ref((String)"indent").plus(JExpr.lit((String)("   " + attr.attribute.name() + ":")).plus((JExpression)this.cm.ref("java.util.Arrays").staticInvoke("toString").arg((JExpression)JExpr._this().ref((JVar)attr.attribute)))));
                continue;
            }
            JFieldRef value = JExpr._this().ref((JVar)attr.attribute);
            if (this.generator.getMapping().get(attr.type) == null) {
                value = value.invoke("toString").arg(JExpr.ref((String)"indent").plus(JExpr.lit((String)"   ")));
            }
            JBlock block = toString2.body()._if(JExpr._this().ref((JVar)attr.attribute).ne(JExpr._null()))._then().block();
            block._if(JExpr.ref((String)"rc").invoke("length").ne(JExpr.lit((int)0)))._then().assignPlus((JAssignmentTarget)JExpr.ref((String)"rc"), JExpr.lit((String)",\n"));
            block.assignPlus((JAssignmentTarget)JExpr.ref((String)"rc"), JExpr.ref((String)"indent").plus(JExpr.lit((String)("   " + attr.attribute.name() + ":")).plus((JExpression)value)));
        }
        toString2.body()._if(JExpr.ref((String)"rc").invoke("length").ne(JExpr.lit((int)0)))._then().assign((JAssignmentTarget)JExpr.ref((String)"rc"), JExpr.lit((String)", {\n").plus(JExpr.ref((String)"rc").plus(JExpr.lit((String)"}"))));
        toString2.body()._return(JExpr.lit((String)("[" + Utilities.toJavaClassName(this.type.getName()))).plus((JExpression)JExpr.ref((String)"rc")).plus(JExpr.lit((String)"]")));
    }

    public boolean isComposite() {
        return this.type.getClazz().equals("composite");
    }

    public boolean isRestricted() {
        return this.type.getClazz().equals("restricted");
    }

    public void generateDescribedFields() {
        Log.info("", new Object[0]);
        Log.info("Generating %s", this.cls().binaryName());
        if (this.isComposite()) {
            for (Object obj : this.type.getEncodingOrDescriptorOrFieldOrChoiceOrDoc()) {
                if (!(obj instanceof Field)) continue;
                Field field = (Field)obj;
                this.processField(field);
            }
        } else if (this.isRestricted()) {
            Field field = new Field();
            field.setName("value");
            field.setType(this.type.getSource());
            this.processField(field);
        }
        this.generateConstructors();
        if (this.isComposite()) {
            this.addDefaults();
            this.generateCount();
        }
        this.fillInReadMethod();
        this.fillInWriteMethod();
        this.fillInSizeMethod();
        this.generateToString();
    }

    private void addDefaults() {
        int mods = 25;
        for (Attribute attr : this.amqpFields) {
            if (attr.defaultValue == null || attr.defaultValue.equals("none")) continue;
            JExpression init = null;
            String d = attr.defaultValue;
            String t = attr.type;
            try {
                if (t.equals("boolean")) {
                    init = JExpr.lit((boolean)Boolean.parseBoolean(d));
                } else if (t.equals("long") || t.equals("uint")) {
                    init = JExpr.lit((long)Long.parseLong(d));
                } else if (t.equals("symbol")) {
                    init = this.cm.ref(Buffer.class).staticInvoke("ascii").arg(JExpr.lit((String)d));
                } else if (t.equals("int") || t.equals("ushort")) {
                    init = JExpr.lit((int)Integer.parseInt(d));
                } else {
                    Log.warn("\n\nDefault value type for %s : %s, Java type : %s not set, value is %s\n\n\n", attr.attribute.name(), attr.type, attr.attribute.type().name(), attr.defaultValue);
                }
            }
            catch (Exception e) {
                Log.warn("\n\nDefault value type for %s : %s, Java type : %s not set, value is %s\n\n\n", attr.attribute.name(), attr.type, attr.attribute.type().name(), attr.defaultValue);
                init = null;
            }
            if (init == null) continue;
            this.cls().field(mods, attr.attribute.type(), Utilities.toStaticName(attr.attribute.name() + "_DEFAULT"), init);
        }
    }

    private void generateConstructors() {
        int numFields = this.amqpFields.size();
        for (int i = 0; i <= numFields; ++i) {
            JMethod constructor = this.cls().constructor(1);
            String log_message = "Adding constructor for : ";
            for (int j = 0; j < i; ++j) {
                log_message = log_message + this.amqpFields.get((int)j).attribute.name() + " ";
                constructor.param(this.amqpFields.get((int)j).attribute.type(), this.amqpFields.get((int)j).attribute.name());
                constructor.body().assign((JAssignmentTarget)JExpr._this().ref(this.amqpFields.get((int)j).attribute.name()), (JExpression)JExpr.ref((String)this.amqpFields.get((int)j).attribute.name()));
            }
            Log.info(log_message.trim(), new Object[0]);
        }
    }

    private void processField(Field field) {
        String fieldType = field.getType();
        String fieldName = Utilities.sanitize(field.getName());
        Log.info("Field type for field %s : %s", fieldName, fieldType);
        if (fieldType.equals("*")) {
            fieldType = this.generator.getAmqpBaseType();
        } else if (this.generator.getDescribed().containsKey(fieldType)) {
            fieldType = this.generator.getDescribedJavaClass().get(field.getType());
        } else if (this.generator.getRestricted().containsKey(fieldType)) {
            fieldType = this.generator.getRestrictedMapping().get(field.getType());
        }
        if (fieldType != null) {
            boolean array = false;
            if (field.getMultiple() != null && field.getMultiple().equals("true")) {
                array = true;
            }
            Log.info("Using field type %s", fieldType);
            String clazz = this.generator.getMapping().get(fieldType);
            Object c = null;
            c = fieldType.equals(this.generator.getAmqpBaseType()) ? this.cm.ref(fieldType) : (clazz == null ? this.cm._getClass(fieldType) : (array ? this.cm.ref(this.generator.getPrimitiveJavaClass().get(fieldType)) : this.cm.ref(clazz)));
            if (array) {
                c = c.array();
            }
            Log.info("%s %s", c.binaryName(), fieldName);
            Attribute attribute = new Attribute();
            attribute.attribute = this.cls().field(2, (JType)c, fieldName);
            attribute.type = fieldType;
            attribute.defaultValue = field.getDefault();
            attribute.required = field.getMandatory() != null ? Boolean.valueOf(Boolean.parseBoolean(field.getMandatory())) : Boolean.FALSE;
            String doc = field.getName() + ":" + field.getType();
            if (field.getLabel() != null) {
                doc = doc + " - " + field.getLabel();
            }
            attribute.attribute.javadoc().add((Object)doc);
            attribute.getter = this.cls().method(1, attribute.attribute.type(), "get" + Utilities.toJavaClassName(fieldName));
            attribute.getter.body()._return((JExpression)JExpr._this().ref((JVar)attribute.attribute));
            attribute.setter = this.cls().method(1, (JType)this.cm.VOID, "set" + Utilities.toJavaClassName(fieldName));
            JVar param = attribute.setter.param(attribute.attribute.type(), fieldName);
            attribute.setter.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)attribute.attribute), (JExpression)param);
            this.amqpFields.add(attribute);
        } else {
            Log.info("Skipping field %s, type not found", field.getName());
        }
    }

    private void generateCount() {
        this.count = this.cls().method(1, (JType)this.cm.INT, "count");
        this.count().body().decl((JType)this.cm.INT, "rc", JExpr.lit((int)this.amqpFields.size()));
        for (int i = this.amqpFields.size(); i > 0; --i) {
            JConditional _if = this.count().body()._if(this.amqpFields.get((int)(i - 1)).attribute.eq(JExpr._null()));
            _if._then().assign((JAssignmentTarget)JExpr.ref((String)"rc"), JExpr.ref((String)"rc").minus(JExpr.lit((int)1)));
            _if._else()._return((JExpression)JExpr.ref((String)"rc"));
        }
        this.count().body()._return((JExpression)JExpr.ref((String)"rc"));
    }

    private void fillInReadMethod() {
        if (this.isComposite()) {
            this.read().body().decl((JType)this.cm.LONG, "count", (JExpression)this.cm.ref(this.generator.getMarshaller() + ".DescribedTypeSupport").staticInvoke("readListHeader").arg((JExpression)JExpr.ref((String)"in")));
        }
        Log.info("Filling in read method for %s", this.type.getName());
        for (Attribute attribute : this.amqpFields) {
            Log.info("%s %s", attribute.type, attribute.attribute.name());
            if (this.isComposite()) {
                this.read().body().assign((JAssignmentTarget)JExpr.ref((String)"count"), JExpr.ref((String)"count").minus(JExpr.lit((int)1)));
                JBlock ifBody = this.read().body()._if(JExpr.ref((String)"count").gte(JExpr.lit((int)0)))._then();
                this.addFieldRead(attribute, ifBody);
                continue;
            }
            this.addFieldRead(attribute, this.read().body());
        }
        if (this.isComposite()) {
            for (Attribute attribute : this.amqpFields) {
                if (!attribute.required.booleanValue()) continue;
                this.read().body()._if(attribute.attribute.eq(JExpr._null()))._then()._throw((JExpression)JExpr._new((JClass)this.cm.ref(RuntimeException.class)).arg("No value specified for mandatory attribute " + attribute.attribute.name()));
            }
        }
    }

    private void addFieldRead(Attribute attribute, JBlock body) {
        if (attribute.attribute.type().isArray()) {
            body.assign((JAssignmentTarget)attribute.attribute, (JExpression)JExpr.cast((JType)attribute.attribute.type(), (JExpression)this.cm.ref("AMQPArray").staticInvoke("read").arg((JExpression)JExpr.ref((String)"in"))));
        } else if (this.generator.getMapping().get(attribute.type) != null) {
            body.assign((JAssignmentTarget)attribute.attribute, (JExpression)this.cm.ref(this.generator.getPrimitiveJavaClass().get(attribute.type)).staticInvoke("read").arg((JExpression)JExpr.ref((String)"in")));
        } else if (!this.generator.getProvides().contains(attribute.type)) {
            body.assign((JAssignmentTarget)attribute.attribute, (JExpression)JExpr.cast((JType)attribute.attribute.type(), (JExpression)this.cm.ref(this.generator.getMarshaller() + ".TypeReader").staticInvoke("read").arg((JExpression)JExpr.ref((String)"in"))));
        }
    }

    private void fillInWriteMethod() {
        this.writeConstructor().body().block().invoke((JExpression)JExpr.ref((String)"CONSTRUCTOR"), "write").arg((JExpression)JExpr.ref((String)"out"));
        this.writeConstructor().body()._return((JExpression)JExpr.cast((JType)this.cm.BYTE, (JExpression)JExpr.lit((int)0)));
        this.write().body().invoke("writeConstructor").arg((JExpression)JExpr.ref((String)"out"));
        this.write().body().invoke("writeBody").arg((JExpression)JExpr.cast((JType)this.cm.BYTE, (JExpression)JExpr.lit((int)0))).arg((JExpression)JExpr.ref((String)"out"));
        if (this.isComposite()) {
            this.writeBody().body().decl((JType)this.cm.LONG, "fieldSize", (JExpression)JExpr._this().invoke("sizeOfFields"));
            this.writeBody().body().decl((JType)this.cm.INT, "count", (JExpression)JExpr._this().invoke("count"));
            this.writeBody().body().staticInvoke(this.cm.ref(this.generator.getMarshaller() + ".DescribedTypeSupport"), "writeListHeader").arg((JExpression)JExpr.ref((String)"fieldSize")).arg((JExpression)JExpr.ref((String)"count")).arg((JExpression)JExpr.ref((String)"out"));
        }
        for (Attribute attribute : this.amqpFields) {
            if (this.isComposite()) {
                this.writeBody().body().assign((JAssignmentTarget)JExpr.ref((String)"count"), JExpr.ref((String)"count").minus(JExpr.lit((int)1)));
                JBlock ifBody = this.writeBody().body()._if(JExpr.ref((String)"count").gte(JExpr.lit((int)0)))._then();
                this.addFieldWrite(attribute, ifBody);
                continue;
            }
            this.addFieldWrite(attribute, this.writeBody().body());
        }
    }

    private void addFieldWrite(Attribute attribute, JBlock body) {
        if (attribute.attribute.type().isArray()) {
            body.staticInvoke(this.cm.ref("AMQPArray"), "write").arg((JExpression)JExpr._this().ref(attribute.attribute.name())).arg((JExpression)JExpr.ref((String)"out"));
        } else if (this.generator.getMapping().get(attribute.type) != null) {
            body.staticInvoke(this.cm.ref(this.generator.getPrimitiveJavaClass().get(attribute.type)), "write").arg((JExpression)JExpr._this().ref(attribute.attribute.name())).arg((JExpression)JExpr.ref((String)"out"));
        } else {
            JConditional conditional = body._if(JExpr.ref((String)attribute.attribute.name()).ne(JExpr._null()));
            conditional._then().invoke((JExpression)JExpr.ref((String)attribute.attribute.name()), "write").arg((JExpression)JExpr.ref((String)"out"));
            conditional._else().invoke((JExpression)JExpr.ref((String)"out"), "writeByte").arg((JExpression)this.generator.registry().cls().staticRef("NULL_FORMAT_CODE"));
        }
    }

    private void fillInSizeMethod() {
        this.size().body()._return(JExpr.invoke((String)"sizeOfConstructor").plus((JExpression)JExpr.invoke((String)"sizeOfBody")));
        this.sizeOfConstructor().body()._return((JExpression)JExpr.ref((String)"CONSTRUCTOR").invoke("size"));
        JMethod sizeOfFields = this.cls().method(4, (JType)this.cm.LONG, "sizeOfFields");
        sizeOfFields.body().decl((JType)this.cm.LONG, "fieldSize", JExpr.lit((long)0L));
        if (this.isComposite()) {
            sizeOfFields.body().decl((JType)this.cm.INT, "count", (JExpression)JExpr._this().invoke(this.count));
        }
        for (Attribute attribute : this.amqpFields) {
            if (this.isComposite()) {
                sizeOfFields.body().assign((JAssignmentTarget)JExpr.ref((String)"count"), JExpr.ref((String)"count").minus(JExpr.lit((int)1)));
                JBlock ifBody = sizeOfFields.body()._if(JExpr.ref((String)"count").gte(JExpr.lit((int)0)))._then();
                this.addFieldSize(attribute, ifBody);
                continue;
            }
            this.addFieldSize(attribute, sizeOfFields.body());
        }
        sizeOfFields.body()._return((JExpression)JExpr.ref((String)"fieldSize"));
        if (this.isComposite()) {
            this.sizeOfBody().body()._return((JExpression)this.cm.ref(this.generator.getMarshaller() + ".DescribedTypeSupport").staticInvoke("fullSizeOfList").arg((JExpression)JExpr._this().invoke("sizeOfFields")).arg((JExpression)JExpr._this().invoke("count")));
        } else {
            this.sizeOfBody().body()._return((JExpression)JExpr._this().invoke("sizeOfFields"));
        }
    }

    private void addFieldSize(Attribute attribute, JBlock body) {
        if (this.generator.getMapping().get(attribute.type) != null) {
            if (attribute.attribute.type().isArray()) {
                body.assign((JAssignmentTarget)JExpr.ref((String)"fieldSize"), JExpr.ref((String)"fieldSize").plus((JExpression)this.generator.registry().cls().staticInvoke("instance").invoke("sizer").invoke("sizeOfArray").arg((JExpression)JExpr.ref((String)attribute.attribute.name()))));
            } else {
                body.assign((JAssignmentTarget)JExpr.ref((String)"fieldSize"), JExpr.ref((String)"fieldSize").plus((JExpression)this.generator.registry().cls().staticInvoke("instance").invoke("sizer").invoke("sizeOf" + Utilities.toJavaClassName(attribute.type)).arg((JExpression)JExpr.ref((String)attribute.attribute.name()))));
            }
        } else if (attribute.attribute.type().isArray()) {
            body.assign((JAssignmentTarget)JExpr.ref((String)"fieldSize"), JExpr.ref((String)"fieldSize").plus((JExpression)this.generator.registry().cls().staticInvoke("instance").invoke("sizer").invoke("sizeOfArray").arg((JExpression)JExpr.ref((String)attribute.attribute.name()))));
        } else {
            JConditional conditional = body._if(JExpr.ref((String)attribute.attribute.name()).ne(JExpr._null()));
            conditional._then().assign((JAssignmentTarget)JExpr.ref((String)"fieldSize"), JExpr.ref((String)"fieldSize").plus((JExpression)JExpr.ref((String)attribute.attribute.name()).invoke("size")));
            conditional._else().assign((JAssignmentTarget)JExpr.ref((String)"fieldSize"), JExpr.ref((String)"fieldSize").plus(JExpr.lit((long)1L)));
        }
    }

    public JMethod count() {
        return this.count;
    }

    class Attribute {
        public String type;
        public Boolean required;
        public String defaultValue;
        public JFieldVar attribute;
        public JMethod getter;
        public JMethod setter;

        Attribute() {
        }
    }
}

