/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.amqp.generator;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.fusesource.amqp.generator.DescribedType;
import org.fusesource.amqp.generator.EncodingPicker;
import org.fusesource.amqp.generator.InterfaceGenerator;
import org.fusesource.amqp.generator.Log;
import org.fusesource.amqp.generator.PrimitiveType;
import org.fusesource.amqp.generator.RestrictedType;
import org.fusesource.amqp.generator.Sizer;
import org.fusesource.amqp.generator.TypeRegistry;
import org.fusesource.amqp.generator.Utilities;
import org.fusesource.amqp.generator.XmlDefinitionParser;
import org.fusesource.amqp.generator.jaxb.Definition;
import org.fusesource.amqp.generator.jaxb.Encoding;
import org.fusesource.amqp.generator.jaxb.Type;
import org.fusesource.hawtbuf.Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator {
    private File[] inputFiles;
    private File outputDirectory;
    private File sourceDirectory;
    private String codecPackagePrefix;
    private String types;
    private HashSet<Definition> definitions = new HashSet();
    private TreeMap<String, Type> primitives = new TreeMap();
    private TreeMap<String, Type> composites = new TreeMap();
    private TreeMap<String, Type> restricted = new TreeMap();
    private TreeMap<String, Type> described = new TreeMap();
    private TreeMap<String, Type> enums = new TreeMap();
    private TreeSet<String> provides = new TreeSet();
    private TreeSet<String> requires = new TreeSet();
    private TreeMap<String, String> requiresMapping = new TreeMap();
    private TreeMap<String, String> restrictedMapping = new TreeMap();
    private TreeMap<String, String> describedJavaClass = new TreeMap();
    private TreeMap<String, String> primitiveJavaClass = new TreeMap();
    private TreeSet<String> classes = new TreeSet();
    private TreeMap<String, String> sections = new TreeMap();
    private TreeMap<String, String> mapping = new TreeMap();
    JCodeModel cm = new JCodeModel();
    private String marshaller = "marshaller";
    private String primitiveEncoder;
    private TypeRegistry registry;
    private EncodingPicker picker;
    private Sizer sizer;
    private final XmlDefinitionParser xmlDefinitionParser = new XmlDefinitionParser(this);
    private final InterfaceGenerator interfaceGenerator = new InterfaceGenerator(this);

    public Generator() {
        this.mapping.put("null", null);
        this.mapping.put("boolean", Boolean.class.getName());
        this.mapping.put("ubyte", Short.class.getName());
        this.mapping.put("ushort", Integer.class.getName());
        this.mapping.put("uint", Long.class.getName());
        this.mapping.put("ulong", BigInteger.class.getName());
        this.mapping.put("byte", Byte.class.getName());
        this.mapping.put("short", Short.class.getName());
        this.mapping.put("int", Integer.class.getName());
        this.mapping.put("long", Long.class.getName());
        this.mapping.put("float", Float.class.getName());
        this.mapping.put("double", Double.class.getName());
        this.mapping.put("decimal32", BigDecimal.class.getName());
        this.mapping.put("decimal64", BigDecimal.class.getName());
        this.mapping.put("decimal128", BigDecimal.class.getName());
        this.mapping.put("char", Character.class.getName());
        this.mapping.put("timestamp", Date.class.getName());
        this.mapping.put("uuid", UUID.class.getName());
        this.mapping.put("binary", Buffer.class.getName());
        this.mapping.put("string", String.class.getName());
        this.mapping.put("symbol", Buffer.class.getName());
        this.mapping.put("list", List.class.getName());
        this.mapping.put("map", "org.fusesource.amqp.types.MapEntries");
        this.mapping.put("array", Object[].class.getName());
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public TreeMap<String, String> getRequiresMapping() {
        return this.requiresMapping;
    }

    public TreeMap<String, String> getDescribedJavaClass() {
        return this.describedJavaClass;
    }

    public void generate() throws Exception {
        this.primitiveEncoder = this.getMarshaller() + "." + "PrimitiveEncoder";
        String typeRegistry = this.getMarshaller() + "." + "TypeRegistry";
        String encodingPicker = this.getMarshaller() + "." + "EncodingPicker";
        String encodingSizer = this.getMarshaller() + "." + "Sizer";
        this.xmlDefinitionParser.parseXML();
        this.buildRestrictedTypeMapping();
        this.generatePrimitiveEncoderDecoder();
        this.registry = new TypeRegistry(this.cm, typeRegistry);
        this.picker = new EncodingPicker(this, encodingPicker);
        this.sizer = new Sizer(this, encodingSizer);
        this.registry.cls().field(26, (JType)this.cm._getClass(this.primitiveEncoder), "ENCODER", JExpr.direct((String)"Encoder.instance()"));
        JMethod singletonAccessor = this.registry.cls().method(1, (JType)this.cm._getClass(this.primitiveEncoder), "encoder");
        singletonAccessor.body()._return((JExpression)JExpr.ref((String)"ENCODER"));
        Log.info("\n%s", this);
        this.outputDirectory.mkdirs();
        try {
            String className;
            Type type;
            ArrayList<PrimitiveType> primitiveTypes = new ArrayList<PrimitiveType>();
            ArrayList<String> filter = new ArrayList<String>();
            filter.add("*");
            filter.add("null");
            for (String key : this.getPrimitives().keySet()) {
                if (filter.contains(key)) continue;
                Type type2 = this.getPrimitives().get(key);
                String className2 = this.getTypes() + "." + "AMQP" + Utilities.toJavaClassName(key);
                this.getPrimitiveJavaClass().put(key, className2);
                primitiveTypes.add(new PrimitiveType(this, className2, type2));
            }
            this.interfaceGenerator.generateAbstractBases();
            ArrayList<DescribedType> describedTypes = new ArrayList<DescribedType>();
            for (String string : this.getDescribed().keySet()) {
                Type type3 = this.getDescribed().get(string);
                String className3 = this.getTypes() + "." + Utilities.toJavaClassName(string);
                this.getDescribedJavaClass().put(string, className3);
                describedTypes.add(new DescribedType(this, className3, type3));
            }
            for (DescribedType describedType : describedTypes) {
                describedType.generateDescribedFields();
            }
            ArrayList<RestrictedType> restrictedTypes = new ArrayList<RestrictedType>();
            for (String key : this.getEnums().keySet()) {
                type = this.getRestricted().get(key);
                className = this.getTypes() + "." + Utilities.toJavaClassName(key);
                restrictedTypes.add(new RestrictedType(this, className, type));
            }
            for (String key : this.getRestricted().keySet()) {
                type = this.getRestricted().get(key);
                if (type.getProvides() == null || this.getEnums().containsKey(key) || this.getDescribed().containsKey(key)) continue;
                className = this.getTypes() + "." + Utilities.toJavaClassName(key);
                restrictedTypes.add(new RestrictedType(this, className, type));
            }
            this.generateDefinitions();
            this.cm.build(this.outputDirectory);
        }
        catch (Exception e) {
            Log.error("Error generating code : %s", e);
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                Log.error("\tat %s.%s(%s:%s)", stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber());
            }
            throw e;
        }
    }

    private void generatePrimitiveEncoderDecoder() throws JClassAlreadyExistsException {
        JDefinedClass enc = this.cm._class(this.primitiveEncoder, ClassType.INTERFACE);
        int mods = 1;
        for (String key : this.primitives.keySet()) {
            Log.info("Adding encoder methods for type %s", key);
            Type type = this.primitives.get(key);
            for (Object obj : type.getEncodingOrDescriptorOrFieldOrChoiceOrDoc()) {
                if (!(obj instanceof Encoding)) continue;
                Encoding encoding = (Encoding)obj;
                String methodName = type.getName();
                if (encoding.getName() != null) {
                    methodName = methodName + "_" + encoding.getName();
                }
                methodName = Utilities.toJavaClassName(methodName);
                Log.info("Writing encode/decode methods for type %s encoding %s using method name %s", type.getName(), encoding.getName(), methodName);
                this.createEncodeDecodeMethods(enc, mods, type, methodName);
            }
        }
    }

    private void createEncodeDecodeMethods(JDefinedClass clazz, int mods, Type type, String methodName) {
        String m = this.mapping.get(type.getName());
        JMethod readMethod = m == null ? clazz.method(mods, (JType)this.cm.ref("java.lang.Object"), "read" + methodName) : clazz.method(mods, (JType)this.cm.ref(m), "read" + methodName);
        readMethod._throws(Exception.class);
        readMethod.param(DataInput.class, "in");
        JMethod writeMethod = clazz.method(mods, (JType)this.cm.VOID, "write" + methodName);
        writeMethod._throws(Exception.class);
        if (m != null) {
            writeMethod.param((JType)this.cm.ref(m), "value");
        }
        writeMethod.param(DataOutput.class, "out");
    }

    private void buildRestrictedTypeMapping() {
        for (String key : this.restricted.keySet()) {
            Type type = this.restricted.get(key);
            String source = type.getSource();
            while (!this.mapping.containsKey(source)) {
                Type t = this.restricted.get(source);
                if (t == null) {
                    Log.info("Skipping restricted type %s with source %s, no primitive type found", type.getName(), source);
                    source = "*";
                    break;
                }
                source = t.getSource();
            }
            this.restrictedMapping.put(type.getName(), source);
        }
    }

    public String toString() {
        StringBuilder rc = new StringBuilder();
        rc.append(String.format("Type classes : %s", this.classes));
        rc.append("\n");
        rc.append("\n");
        rc.append(String.format("Primitive types : %s", this.names(this.primitives)));
        rc.append("\n");
        rc.append("\n");
        rc.append(String.format("Restricted types : %s", this.names(this.restricted)));
        rc.append("\n");
        rc.append("\n");
        rc.append("Restricted mapping : \n");
        for (String key : this.restrictedMapping.keySet()) {
            String value = this.restrictedMapping.get(key);
            rc.append(String.format("%s = %s\n", key, value));
        }
        rc.append("\n");
        rc.append("\n");
        rc.append(String.format("Composite types : %s", this.names(this.composites)));
        rc.append("\n");
        rc.append("\n");
        rc.append(String.format("Described types : %s", this.names(this.described)));
        rc.append("\n");
        rc.append("\n");
        rc.append(String.format("Provides : %s", this.provides));
        rc.append("\n");
        rc.append("\n");
        rc.append(String.format("Requires : %s", this.requires));
        rc.append("\n");
        return rc.toString();
    }

    private String names(Map<String, Type> set) {
        return set.keySet().toString();
    }

    private void generateDefinitions() throws Exception {
        JDefinedClass defs = this.cm._class(this.codecPackagePrefix + ".Definitions", ClassType.INTERFACE);
        Log.info("Creating %s", defs.binaryName());
        for (Definition def : this.definitions) {
            Log.info("Adding field %s with value %s", def.getName(), def.getValue());
            JFieldVar field = defs.field(17, String.class, Utilities.toStaticName(def.getName()), JExpr.lit((String)def.getValue()));
            field.javadoc().add((Object)def.getLabel());
        }
    }

    public JClass getBitUtils() {
        return this.cm.ref(this.getCodecPackagePrefix() + ".BitUtils");
    }

    public File[] getInputFiles() {
        return this.inputFiles;
    }

    public void setInputFiles(File ... inputFiles) {
        this.inputFiles = inputFiles;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public String getCodecPackagePrefix() {
        return this.codecPackagePrefix;
    }

    public void setCodecPackagePrefix(String codecPackagePrefix) {
        this.codecPackagePrefix = codecPackagePrefix;
    }

    public JCodeModel getCm() {
        return this.cm;
    }

    public String getInterfaces() {
        return this.getTypes();
    }

    public String getTypes() {
        return this.types;
    }

    public void setTypes(String types) {
        this.types = types;
    }

    public Map<String, String> getRestrictedMapping() {
        return this.restrictedMapping;
    }

    public Map<String, Type> getEnums() {
        return this.enums;
    }

    public Map<String, Type> getDescribed() {
        return this.described;
    }

    public Set<String> getRequires() {
        return this.requires;
    }

    public Set<Definition> getDefinitions() {
        return this.definitions;
    }

    public Map<String, Type> getPrimitives() {
        return this.primitives;
    }

    public Map<String, Type> getComposites() {
        return this.composites;
    }

    public Map<String, Type> getRestricted() {
        return this.restricted;
    }

    public Set<String> getProvides() {
        return this.provides;
    }

    public Set<String> getClasses() {
        return this.classes;
    }

    public Map<String, String> getSections() {
        return this.sections;
    }

    public Map<String, String> getMapping() {
        return this.mapping;
    }

    public String getMarshaller() {
        return this.getCodecPackagePrefix() + "." + this.marshaller;
    }

    public TypeRegistry registry() {
        return this.registry;
    }

    public EncodingPicker picker() {
        return this.picker;
    }

    public String getAmqpBaseType() {
        return this.getInterfaces() + "." + "AMQPType";
    }

    public Map<String, String> getPrimitiveJavaClass() {
        return this.primitiveJavaClass;
    }

    public Sizer sizer() {
        return this.sizer;
    }
}

