/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.amqp.generator;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import java.io.IOException;
import org.fusesource.amqp.generator.Generator;
import org.fusesource.amqp.generator.Log;
import org.fusesource.amqp.generator.Utilities;

public class InterfaceGenerator {
    private final Generator generator;

    public InterfaceGenerator(Generator generator) {
        this.generator = generator;
    }

    void generateAbstractBases() throws JClassAlreadyExistsException, IOException {
        for (String base : this.generator.getProvides()) {
            String pkg = this.generator.getInterfaces() + ".";
            String name = pkg + "AMQP" + Utilities.toJavaClassName(base);
            Log.info("generating interface with name %s", name);
            JDefinedClass cls = this.generator.getCm()._class(name, ClassType.INTERFACE);
            cls._implements(this.generator.getCm().ref(this.generator.getAmqpBaseType()));
        }
    }
}

