/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.amqp.generator;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JSwitch;
import com.sun.codemodel.JType;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.amqp.generator.AmqpDefinedType;
import org.fusesource.amqp.generator.Generator;
import org.fusesource.amqp.generator.Log;
import org.fusesource.amqp.generator.Utilities;
import org.fusesource.amqp.generator.jaxb.Encoding;
import org.fusesource.amqp.generator.jaxb.Type;

public class PrimitiveType
extends AmqpDefinedType {
    private JFieldVar value;
    private List<JFieldVar> formatCodes = new ArrayList<JFieldVar>();
    private JMethod getValue;
    private JMethod setValue;
    private JMethod noArgConstructor;
    private JMethod valueConstructor;
    private JMethod encodingPicker;
    private JMethod equalsTypeSpecific;
    private JMethod equalsGeneric;
    private JMethod toString;
    private JMethod hashCode;
    private JMethod staticRead;
    private JMethod staticReadConstructor;
    private JMethod staticReadBody;
    private JMethod staticWrite;
    private JMethod staticWriteBody;
    private JMethod staticWriteConstructor;
    private JMethod sizer;
    private String highestWidthField;

    public PrimitiveType(Generator generator, String className, Type type) throws JClassAlreadyExistsException {
        super(generator, className, type);
    }

    protected void createGetArrayConstructor() {
        this.getArrayConstructor = this.cls().method(1, (JType)this.cm.ref("Object"), "getArrayConstructor");
        this.getArrayConstructor.body()._return((JExpression)JExpr.ref((String)this.highestWidthField));
    }

    protected void createInitialFields() {
        this.value = this.cls().field(2, (JType)this.getJavaType(), "value");
        this.generateConstructors();
        this.getValue = this.cls().method(1, (JType)this.getJavaType(), "getValue");
        this.getValue.body()._return((JExpression)JExpr._this().ref("value"));
        this.setValue = this.cls().method(1, (JType)this.cm.VOID, "setValue");
        this.setValue.param((JType)this.getJavaType(), "value");
        this.setValue.body().block().assign((JAssignmentTarget)JExpr._this().ref("value"), (JExpression)JExpr.ref((String)"value"));
        this.encodingPicker = this.generator.picker().cls().method(1, (JType)this.cm.BYTE, "choose" + Utilities.toJavaClassName(this.type.getName() + "Encoding"));
        this.encodingPicker.param((JType)this.getJavaType(), "value");
        this.generateSize();
        this.generateEquals();
        this.generateHashCode();
        this.generateToString();
        this.sizeOfConstructor().body()._return(JExpr.lit((int)1));
        this.sizeOfBody().body()._return(JExpr.invoke((String)"size").minus((JExpression)JExpr.invoke((JMethod)this.sizeOfConstructor)));
    }

    private void generateHashCode() {
        this.hashCode = this.cls().method(1, (JType)this.cm.INT, "hashCode");
        this.hashCode.body().block()._if(JExpr._this().ref("value").eq(JExpr._null()))._then()._return((JExpression)JExpr.dotclass((JClass)this.cls()).invoke("hashCode"));
        this.hashCode.body().block()._return((JExpression)JExpr._this().ref("value").invoke("hashCode"));
    }

    private void generateSize() {
        this.sizer = this.generator.sizer().cls().method(1, (JType)this.cm.LONG, "sizeOf" + Utilities.toJavaClassName(this.type.getName()));
        this.sizer.param((JType)this.getJavaType(), "value");
        this.size().body()._return((JExpression)this.generator.registry().cls().staticInvoke("instance").invoke("sizer").invoke("sizeOf" + Utilities.toJavaClassName(this.type.getName())).arg((JExpression)JExpr.ref((String)"value")));
    }

    private void generateConstructors() {
        this.noArgConstructor = this.cls().constructor(1);
        this.noArgConstructor.body().block().assign((JAssignmentTarget)JExpr._this().ref("value"), JExpr._null());
        this.valueConstructor = this.cls().constructor(1);
        this.valueConstructor.param((JType)this.getJavaType(), "value");
        this.valueConstructor.body().block().assign((JAssignmentTarget)JExpr._this().ref("value"), (JExpression)JExpr.ref((String)"value"));
    }

    private void generateToString() {
        this.toString = this.cls().method(1, (JType)this.cm.ref("java.lang.String"), "toString");
        this.toString.body()._return((JExpression)JExpr.ref((String)"this").invoke("toString").arg(JExpr.lit((String)"")));
        JMethod toString2 = this.cls().method(1, (JType)this.cm.ref("java.lang.String"), "toString");
        toString2.param(String.class, "indent");
        toString2.body()._if(JExpr._this().ref("value").eq(JExpr._null()))._then().block()._return(JExpr.lit((String)"null"));
        if (this.type.getName().equals("array")) {
            toString2.body()._return((JExpression)this.cm.ref("java.util.Arrays").staticInvoke("toString").arg((JExpression)JExpr._this().ref("value")));
        } else {
            toString2.body()._return((JExpression)JExpr._this().ref("value").invoke("toString"));
        }
    }

    private void generateEquals() {
        this.equalsGeneric = this.cls().method(1, (JType)this.cm.BOOLEAN, "equals");
        this.equalsGeneric.param((JType)this.cm.ref("java.lang.Object"), "other");
        this.equalsGeneric.body().block()._if(JExpr._this().eq((JExpression)JExpr.ref((String)"other")))._then()._return(JExpr.TRUE);
        this.equalsGeneric.body().block()._if(JExpr.ref((String)"other").eq(JExpr._null()).cor(JExpr.ref((String)"other")._instanceof((JType)this.cls()).not()))._then()._return(JExpr.FALSE);
        this.equalsGeneric.body().block()._return((JExpression)JExpr._this().invoke("equals").arg((JExpression)JExpr.cast((JType)this.cls(), (JExpression)JExpr.ref((String)"other"))));
        this.equalsTypeSpecific = this.cls().method(1, (JType)this.cm.BOOLEAN, "equals");
        this.equalsTypeSpecific.param((JType)this.cls(), "other");
        this.equalsTypeSpecific.body().block()._if(JExpr.ref((String)"other").eq(JExpr._null()))._then()._return(JExpr.FALSE);
        JConditional test = this.equalsTypeSpecific.body().block()._if(JExpr._this().ref("value").eq(JExpr._null()).cand(JExpr.ref((String)"other").invoke("getValue").ne(JExpr._null())));
        test._then().block()._return(JExpr.FALSE);
        JConditional test2 = test._elseif(JExpr._this().ref("value").ne(JExpr._null()).cand(JExpr.ref((String)"other").invoke("getValue").eq(JExpr._null())));
        test2._then().block()._return(JExpr.FALSE);
        JConditional test3 = test2._elseif(JExpr._this().ref("value").eq(JExpr._null()).cand(JExpr.ref((String)"other").invoke("getValue").eq(JExpr._null())));
        test3._then().block()._return(JExpr.TRUE);
        test3._else().block()._return((JExpression)JExpr._this().ref("value").invoke("equals").arg((JExpression)JExpr.ref((String)"other").invoke("getValue")));
    }

    protected void createStaticBlock() {
        this.initWriteMethods();
        JSwitch writeBodySwitchBlock = this.staticWriteBody.body().block()._switch((JExpression)JExpr.ref((String)"formatCode"));
        this.staticRead().body().decl((JType)this.cm.BYTE, "formatCode", (JExpression)JExpr.ref((String)"in").invoke("readByte"));
        JSwitch staticReadSwitchBlock = this.staticRead().body().block()._switch((JExpression)JExpr.ref((String)"formatCode"));
        staticReadSwitchBlock._case((JExpression)this.generator.registry().cls().staticRef("NULL_FORMAT_CODE")).body()._return((JExpression)JExpr.cast((JType)this.getJavaType(), (JExpression)this.generator.registry().cls().staticInvoke("instance").invoke("encoder").invoke("readNull").arg((JExpression)JExpr.ref((String)"in"))));
        JSwitch readSwitchBlock = this.read().body()._switch((JExpression)JExpr.ref((String)"formatCode"));
        writeBodySwitchBlock._case((JExpression)this.generator.registry().cls().staticRef("NULL_FORMAT_CODE")).body()._break();
        int highestWidth = 0;
        for (Object obj : this.type.getEncodingOrDescriptorOrFieldOrChoiceOrDoc()) {
            if (!(obj instanceof Encoding)) continue;
            Encoding encoding = (Encoding)obj;
            String fieldName = this.type.getName();
            if (encoding.getName() != null) {
                fieldName = fieldName + "_" + encoding.getName();
            }
            Log.info("encoding name %s", fieldName);
            String staticCodeFieldName = Utilities.toStaticName(fieldName + "_CODE");
            this.cls().field(25, (JType)this.cm.BYTE, staticCodeFieldName, JExpr.direct((String)("(byte)" + encoding.getCode())));
            this.cls().init().add((JStatement)this.generator.registry().cls().staticInvoke("instance").invoke("getPrimitiveFormatCodeMap").invoke("put").arg((JExpression)JExpr.ref((String)staticCodeFieldName)).arg(this.cls().dotclass()));
            int width = Integer.parseInt(encoding.getWidth());
            if (width > highestWidth) {
                highestWidth = width;
                this.highestWidthField = staticCodeFieldName;
            }
            this.cls().field(25, (JType)this.cm.INT, Utilities.toStaticName(fieldName + "_WIDTH"), JExpr.lit((int)width));
            readSwitchBlock._case((JExpression)JExpr.ref((String)staticCodeFieldName)).body().assign((JAssignmentTarget)JExpr._this().ref("value"), (JExpression)this.generator.registry().cls().staticInvoke("instance").invoke("encoder").invoke("read" + Utilities.toJavaClassName(fieldName)).arg((JExpression)JExpr.ref((String)"in")))._break();
            staticReadSwitchBlock._case((JExpression)JExpr.ref((String)staticCodeFieldName)).body()._return((JExpression)this.generator.registry().cls().staticInvoke("instance").invoke("encoder").invoke("read" + Utilities.toJavaClassName(fieldName)).arg((JExpression)JExpr.ref((String)"in")));
            writeBodySwitchBlock._case((JExpression)JExpr.ref((String)staticCodeFieldName)).body().add((JStatement)this.generator.registry().cls().staticInvoke("instance").invoke("encoder").invoke("write" + Utilities.toJavaClassName(fieldName)).arg((JExpression)JExpr.ref((String)"value")).arg((JExpression)JExpr.ref((String)"out")))._break();
        }
        readSwitchBlock._default().body()._throw((JExpression)JExpr._new((JClass)this.cm.ref(Exception.class)).arg(JExpr.lit((String)("Unknown format code for " + this.type.getName() + " : 0x")).plus((JExpression)this.cm.ref("java.lang.String").staticInvoke("format").arg("%x").arg((JExpression)JExpr.ref((String)"formatCode")))));
        staticReadSwitchBlock._default().body()._throw((JExpression)JExpr._new((JClass)this.cm.ref(Exception.class)).arg(JExpr.lit((String)("Unknown format code for " + this.type.getName() + " : 0x")).plus((JExpression)this.cm.ref("java.lang.String").staticInvoke("format").arg("%x").arg((JExpression)JExpr.ref((String)"formatCode")))));
        writeBodySwitchBlock._default().body()._throw((JExpression)JExpr._new((JClass)this.cm.ref(Exception.class)).arg(JExpr.lit((String)("Unknown format code for " + this.type.getName() + " : 0x")).plus((JExpression)this.cm.ref("java.lang.String").staticInvoke("format").arg("%x").arg((JExpression)JExpr.ref((String)"formatCode")))));
    }

    private void initWriteMethods() {
        this.write().body().staticInvoke((JClass)this.cls(), "write").arg((JExpression)JExpr._this().ref("value")).arg((JExpression)JExpr.ref((String)"out"));
        this.writeConstructor().body()._return((JExpression)this.cls().staticInvoke("writeConstructor").arg((JExpression)JExpr._this().ref("value")).arg((JExpression)JExpr.ref((String)"out")));
        this.writeBody().body().staticInvoke((JClass)this.cls(), "writeBody").arg((JExpression)JExpr.ref((String)"formatCode")).arg((JExpression)JExpr._this().ref("value")).arg((JExpression)JExpr.ref((String)"out"));
        this.staticWrite().body().decl((JType)this.cm.BYTE, "formatCode", (JExpression)this.cls().staticInvoke("writeConstructor").arg((JExpression)JExpr.ref((String)"value")).arg((JExpression)JExpr.ref((String)"out")));
        this.staticWrite().body().staticInvoke((JClass)this.cls(), "writeBody").arg((JExpression)JExpr.ref((String)"formatCode")).arg((JExpression)JExpr.ref((String)"value")).arg((JExpression)JExpr.ref((String)"out"));
        this.staticWriteConstructor = this.cls().method(17, (JType)this.cm.BYTE, "writeConstructor");
        this.staticWriteConstructor._throws(Exception.class);
        this.staticWriteConstructor.param((JType)this.getJavaType(), "value");
        this.staticWriteConstructor.param(DataOutput.class, "out");
        this.staticWriteConstructor.body().decl((JType)this.cm.BYTE, "formatCode", (JExpression)this.generator.registry().cls().staticInvoke("instance").invoke("picker").invoke("choose" + Utilities.toJavaClassName(this.type.getName() + "Encoding")).arg((JExpression)JExpr.ref((String)"value")));
        this.staticWriteConstructor.body().invoke((JExpression)JExpr.ref((String)"out"), "writeByte").arg((JExpression)JExpr.ref((String)"formatCode"));
        this.staticWriteConstructor.body()._return((JExpression)JExpr.ref((String)"formatCode"));
        this.staticWriteBody = this.cls().method(17, (JType)this.cm.VOID, "writeBody");
        this.staticWriteBody._throws(Exception.class);
        this.staticWriteBody.param((JType)this.cm.BYTE, "formatCode");
        this.staticWriteBody.param((JType)this.getJavaType(), "value");
        this.staticWriteBody.param(DataOutput.class, "out");
    }

    private JMethod staticWrite() {
        if (this.staticWrite == null) {
            this.staticWrite = this.cls().method(17, (JType)this.cm.VOID, "write");
            this.staticWrite._throws(Exception.class);
            this.staticWrite.param((JType)this.getJavaType(), "value");
            this.staticWrite.param(DataOutput.class, "out");
        }
        return this.staticWrite;
    }

    private JMethod staticRead() {
        if (this.staticRead == null) {
            this.staticRead = this.cls().method(17, (JType)this.getJavaType(), "read");
            this.staticRead._throws(Exception.class);
            this.staticRead.param(DataInput.class, "in");
        }
        return this.staticRead;
    }

    public JClass getJavaType() {
        String name = this.generator.getMapping().get(this.type.getName());
        if (name == null) {
            return null;
        }
        return this.cm.ref(name);
    }
}

