/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.amqp.generator;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JCase;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JSwitch;
import com.sun.codemodel.JType;
import org.fusesource.amqp.generator.AmqpDefinedType;
import org.fusesource.amqp.generator.Generator;
import org.fusesource.amqp.generator.Log;
import org.fusesource.amqp.generator.Utilities;
import org.fusesource.amqp.generator.jaxb.Choice;
import org.fusesource.amqp.generator.jaxb.Type;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictedType
extends AmqpDefinedType {
    JClass basePrimitiveType;

    public RestrictedType(Generator generator, String className, Type type) throws JClassAlreadyExistsException {
        super(generator, className, type);
    }

    @Override
    protected void init() {
        if (this.type.getProvides() != null) {
            this.cls()._implements(this.cm.ref(this.generator.getInterfaces() + ".AMQP" + Utilities.toJavaClassName(this.type.getProvides())));
        } else {
            this.cls()._implements(this.cm.ref(this.generator.getAmqpBaseType()));
        }
        String source = this.generator.getPrimitiveJavaClass().get(this.type.getSource());
        if (source == null) {
            source = this.generator.getTypes() + "." + Utilities.toJavaClassName(this.type.getSource());
        }
        String key = this.generator.getRestrictedMapping().get(this.type.getName());
        this.basePrimitiveType = this.cm.ref(this.generator.getMapping().get(key));
        this.cls()._extends(this.cm.ref(source));
        this.cls().constructor(1).body().block();
        JMethod setter = this.cls().constructor(1);
        setter.param((JType)this.basePrimitiveType, "value");
        setter.body().block().assign((JAssignmentTarget)JExpr._this().ref("value"), (JExpression)JExpr.ref((String)"value"));
        this.generateConstants();
        this.generateValueOf();
    }

    @Override
    protected void createGetArrayConstructor() {
    }

    private void generateConstants() {
        for (Object obj : this.type.getEncodingOrDescriptorOrFieldOrChoiceOrDoc()) {
            if (!(obj instanceof Choice)) continue;
            Choice constant = (Choice)obj;
            int mods = 25;
            String name = Utilities.toStaticName(constant.getName());
            Class<Buffer> clazz = Buffer.class;
            if (this.isBase(clazz)) {
                this.cls().field(mods, (JType)this.cls(), name, (JExpression)JExpr._new((JClass)this.cls()).arg((JExpression)JExpr._new((JClass)this.cm.ref(AsciiBuffer.class)).arg(JExpr.lit((String)constant.getValue()))));
                continue;
            }
            if (this.isBase(Boolean.class)) {
                if (Boolean.parseBoolean(constant.getValue())) {
                    this.cls().field(mods, (JType)this.cls(), name, (JExpression)JExpr._new((JClass)this.cls()).arg((JExpression)this.cm.ref("java.lang.Boolean").staticRef("TRUE")));
                    continue;
                }
                this.cls().field(mods, (JType)this.cls(), name, (JExpression)JExpr._new((JClass)this.cls()).arg((JExpression)this.cm.ref("java.lang.Boolean").staticRef("FALSE")));
                continue;
            }
            if (this.isBase(Short.class)) {
                this.cls().field(mods, (JType)this.cls(), name, (JExpression)JExpr._new((JClass)this.cls()).arg((JExpression)JExpr._new((JClass)this.cm.ref("java.lang.Short")).arg((JExpression)JExpr.cast((JType)this.cm.ref("short"), (JExpression)JExpr.lit((int)Short.parseShort(constant.getValue()))))));
                continue;
            }
            if (this.isBase(Long.class)) {
                this.cls().field(mods, (JType)this.cls(), name, (JExpression)JExpr._new((JClass)this.cls()).arg((JExpression)JExpr._new((JClass)this.cm.ref("java.lang.Long")).arg(JExpr.lit((long)Long.parseLong(constant.getValue())))));
                continue;
            }
            Log.warn("Not generating constant %s with type %s for restricted type %s!", constant.getName(), this.basePrimitiveType.name(), this.type.getName());
        }
    }

    private boolean isBase(Class<?> clazz) {
        return this.basePrimitiveType.equals(this.cm.ref(clazz));
    }

    private void generateValueOf() {
        Class<Buffer> t = Buffer.class;
        if (this.isBase(t) || this.isBase(Boolean.class)) {
            JMethod valueOf = this.cls().method(17, (JType)this.cls(), "valueOf");
            valueOf.param((JType)this.basePrimitiveType, "value");
            valueOf.body()._if(JExpr.ref((String)"value").eq(JExpr._null()))._then()._return(JExpr._null());
            for (Object obj : this.type.getEncodingOrDescriptorOrFieldOrChoiceOrDoc()) {
                if (!(obj instanceof Choice)) continue;
                Choice constant = (Choice)obj;
                JInvocation value = JExpr.ref((String)Utilities.toStaticName(constant.getName())).invoke("getValue");
                valueOf.body()._if(JExpr.ref((String)"value").eq((JExpression)value))._then()._return((JExpression)JExpr.ref((String)Utilities.toStaticName(constant.getName())));
            }
            valueOf.body()._throw((JExpression)JExpr._new((JClass)this.cm.ref("java.lang.IllegalArgumentException")).arg(JExpr.lit((String)("invalid " + Utilities.toJavaClassName(this.type.getName()) + " value: ")).plus((JExpression)JExpr.ref((String)"value"))));
        } else if (this.isBase(Short.class) || this.isBase(Integer.class) || this.isBase(Long.class)) {
            JMethod valueOf = this.cls().method(17, (JType)this.cls(), "valueOf");
            valueOf.param((JType)this.basePrimitiveType, "value");
            valueOf.body()._if(JExpr.ref((String)"value").eq(JExpr._null()))._then()._return(JExpr._null());
            JSwitch _switch = null;
            if (this.isBase(Short.class)) {
                _switch = valueOf.body()._switch((JExpression)JExpr.ref((String)"value").invoke("shortValue"));
            } else if (this.isBase(Integer.class)) {
                _switch = valueOf.body()._switch((JExpression)JExpr.ref((String)"value").invoke("intValue"));
            } else if (this.isBase(Long.class)) {
                _switch = valueOf.body()._switch((JExpression)JExpr.ref((String)"value").invoke("intValue"));
            }
            for (Object obj : this.type.getEncodingOrDescriptorOrFieldOrChoiceOrDoc()) {
                if (!(obj instanceof Choice)) continue;
                Choice constant = (Choice)obj;
                JCase _case = null;
                if (this.isBase(Short.class)) {
                    _case = _switch._case(JExpr.lit((int)Short.parseShort(constant.getValue())));
                } else if (this.isBase(Integer.class)) {
                    _case = _switch._case(JExpr.lit((int)Integer.parseInt(constant.getValue())));
                } else if (this.isBase(Long.class)) {
                    _case = _switch._case(JExpr.lit((int)((int)Long.parseLong(constant.getValue()))));
                }
                if (_case == null) continue;
                _case.body()._return((JExpression)JExpr.ref((String)Utilities.toStaticName(constant.getName())));
            }
            valueOf.body()._throw((JExpression)JExpr._new((JClass)this.cm.ref("java.lang.IllegalArgumentException")).arg(JExpr.lit((String)("invalid " + Utilities.toJavaClassName(this.type.getName()) + " value: ")).plus((JExpression)JExpr.ref((String)"value"))));
        }
    }

    @Override
    protected void createStaticBlock() {
    }

    @Override
    protected void createInitialFields() {
    }
}

