/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.amqp.generator;

import java.util.HashMap;
import java.util.Map;
import org.fusesource.amqp.generator.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static HashMap<String, String> substitutions = new HashMap();
    private static HashMap<String, String> fixed_substitutions = new HashMap();

    public static String filter(String name) {
        return Utilities.filter(Utilities.filter(name, substitutions), fixed_substitutions);
    }

    private static String filter(String word, Map<String, String> filters) {
        String rc = word;
        for (String needle : filters.keySet()) {
            String substitute = filters.get(needle);
            if (!rc.contains(needle)) continue;
            Log.info("Replacing \"%s\" in '%s\" with \"%s\"", needle, rc, substitute);
            rc = rc.replaceAll(needle, substitute);
        }
        return rc;
    }

    public static String sanitize(String name) {
        String rc = name.trim();
        rc = rc.replace('-', '_');
        return rc;
    }

    public static String toStaticName(String name) {
        return Utilities.sanitize(name.toUpperCase());
    }

    public static String toJavaClassName(String name) {
        String[] strs;
        String rc = "";
        for (String str : strs = Utilities.sanitize(name).split("_")) {
            rc = rc + str.substring(0, 1).toUpperCase();
            rc = rc + str.substring(1);
        }
        return Utilities.filter(rc);
    }

    static {
        substitutions.put("Amqp", "AMQP");
        substitutions.put("Ubyte", "UByte");
        substitutions.put("Ushort", "UShort");
        substitutions.put("Uint", "UInt");
        substitutions.put("Ulong", "ULong");
        substitutions.put("Uuid", "UUID");
        substitutions.put("Sasl", "SASL");
        substitutions.put("Id", "ID");
        substitutions.put("TimeOut", "Timeout");
        substitutions.put("Ttl", "TTL");
        substitutions.put("Ieee", "IEEE");
        substitutions.put("Vbin", "VBIN");
        substitutions.put("Utf", "UTF");
        substitutions.put("ListList", "List");
        substitutions.put("MapMap", "MapEntries");
        substitutions.put("ArrayArray", "Array");
        substitutions.put("Smalllong", "SmallLong");
        substitutions.put("Smallint", "SmallInt");
        substitutions.put("Smallulong", "SmallULong");
        substitutions.put("Smalluint", "SmallUInt");
        substitutions.put("TimestampMs", "TimestampMS");
        fixed_substitutions.put("IDle", "Idle");
    }
}

