/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.amqp.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.fusesource.amqp.generator.Generator;
import org.fusesource.amqp.generator.Log;
import org.fusesource.amqp.generator.jaxb.Amqp;
import org.fusesource.amqp.generator.jaxb.Choice;
import org.fusesource.amqp.generator.jaxb.Definition;
import org.fusesource.amqp.generator.jaxb.Descriptor;
import org.fusesource.amqp.generator.jaxb.Field;
import org.fusesource.amqp.generator.jaxb.Section;
import org.fusesource.amqp.generator.jaxb.Type;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlDefinitionParser {
    private final Generator generator;

    public XmlDefinitionParser(Generator generator) {
        this.generator = generator;
    }

    void parseXML() throws JAXBException, SAXException, ParserConfigurationException, IOException {
        JAXBContext jc = JAXBContext.newInstance((String)Amqp.class.getPackage().getName());
        for (File inputFile : this.generator.getInputFiles()) {
            BufferedReader reader = new BufferedReader(new FileReader(inputFile));
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(false);
            XMLReader xmlreader = parserFactory.newSAXParser().getXMLReader();
            xmlreader.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    InputSource is = null;
                    if (systemId != null && systemId.endsWith("amqp.dtd")) {
                        is = new InputSource();
                        is.setPublicId(publicId);
                        is.setSystemId(Generator.class.getResource("amqp.dtd").toExternalForm());
                    }
                    return is;
                }
            });
            SAXSource er = new SAXSource(xmlreader, new InputSource(reader));
            Amqp amqp = (Amqp)unmarshaller.unmarshal((Source)er);
            for (Object docOrSection : amqp.getDocOrSection()) {
                if (!(docOrSection instanceof Section)) continue;
                Section section = (Section)docOrSection;
                for (Object docOrDefinitionOrType : section.getDocOrDefinitionOrType()) {
                    if (docOrDefinitionOrType instanceof Type) {
                        Type type = (Type)docOrDefinitionOrType;
                        Log.info("Section : %s - Type name=%s class=%s provides=%s source=%s", section.getName(), type.getName(), type.getClazz(), type.getProvides(), type.getSource());
                        this.generator.getClasses().add(type.getClazz());
                        this.generator.getSections().put(type.getName(), section.getName());
                        for (Object obj : type.getEncodingOrDescriptorOrFieldOrChoiceOrDoc()) {
                            Field field;
                            if (obj instanceof Descriptor) {
                                this.generator.getDescribed().put(type.getName(), type);
                            }
                            if (obj instanceof Choice) {
                                this.generator.getEnums().put(type.getName(), type);
                            }
                            if (!(obj instanceof Field) || (field = (Field)obj).getRequires() == null) continue;
                            this.generator.getRequires().add(field.getRequires());
                        }
                        if (type.getProvides() != null) {
                            String[] types;
                            Log.info("Adding provides : %s", type.getProvides());
                            for (String t : types = type.getProvides().split(",")) {
                                this.generator.getProvides().add(t.trim());
                            }
                        }
                        if (type.getClazz().startsWith("primitive")) {
                            this.generator.getPrimitives().put(type.getName(), type);
                            continue;
                        }
                        if (type.getClazz().startsWith("restricted")) {
                            this.generator.getRestricted().put(type.getName(), type);
                            continue;
                        }
                        if (!type.getClazz().startsWith("composite")) continue;
                        this.generator.getComposites().put(type.getName(), type);
                        continue;
                    }
                    if (!(docOrDefinitionOrType instanceof Definition)) continue;
                    Definition def = (Definition)docOrDefinitionOrType;
                    this.generator.getDefinitions().add(def);
                }
            }
            reader.close();
        }
    }
}

