
package org.fusesource.amqp.codec.marshaller;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.fusesource.amqp.types.MapEntries;
import org.fusesource.hawtbuf.Buffer;

public interface EncodingPicker {


    public byte chooseArrayEncoding(Object[] value);

    public byte chooseBinaryEncoding(Buffer value);

    public byte chooseBooleanEncoding(Boolean value);

    public byte chooseByteEncoding(Byte value);

    public byte chooseCharEncoding(Character value);

    public byte chooseDecimal128Encoding(BigDecimal value);

    public byte chooseDecimal32Encoding(BigDecimal value);

    public byte chooseDecimal64Encoding(BigDecimal value);

    public byte chooseDoubleEncoding(Double value);

    public byte chooseFloatEncoding(Float value);

    public byte chooseIntEncoding(Integer value);

    public byte chooseListEncoding(List value);

    public byte chooseLongEncoding(Long value);

    public byte chooseMapEncoding(MapEntries value);

    public byte chooseShortEncoding(Short value);

    public byte chooseStringEncoding(String value);

    public byte chooseSymbolEncoding(Buffer value);

    public byte chooseTimestampEncoding(Date value);

    public byte chooseUByteEncoding(Short value);

    public byte chooseUIntEncoding(Long value);

    public byte chooseULongEncoding(BigInteger value);

    public byte chooseUShortEncoding(Integer value);

    public byte chooseUUIDEncoding(UUID value);

}
