
package org.fusesource.amqp.codec.marshaller;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.fusesource.hawtbuf.Buffer;

public interface PrimitiveEncoder {


    public Object[] readArray8(DataInput in)
        throws Exception
    ;

    public void writeArray8(Object[] value, DataOutput out)
        throws Exception
    ;

    public Object[] readArray32(DataInput in)
        throws Exception
    ;

    public void writeArray32(Object[] value, DataOutput out)
        throws Exception
    ;

    public Buffer readBinaryVBIN8(DataInput in)
        throws Exception
    ;

    public void writeBinaryVBIN8(Buffer value, DataOutput out)
        throws Exception
    ;

    public Buffer readBinaryVBIN32(DataInput in)
        throws Exception
    ;

    public void writeBinaryVBIN32(Buffer value, DataOutput out)
        throws Exception
    ;

    public Boolean readBoolean(DataInput in)
        throws Exception
    ;

    public void writeBoolean(Boolean value, DataOutput out)
        throws Exception
    ;

    public Boolean readBooleanTrue(DataInput in)
        throws Exception
    ;

    public void writeBooleanTrue(Boolean value, DataOutput out)
        throws Exception
    ;

    public Boolean readBooleanFalse(DataInput in)
        throws Exception
    ;

    public void writeBooleanFalse(Boolean value, DataOutput out)
        throws Exception
    ;

    public Byte readByte(DataInput in)
        throws Exception
    ;

    public void writeByte(Byte value, DataOutput out)
        throws Exception
    ;

    public Character readCharUTF32(DataInput in)
        throws Exception
    ;

    public void writeCharUTF32(Character value, DataOutput out)
        throws Exception
    ;

    public BigDecimal readDecimal128IEEE754(DataInput in)
        throws Exception
    ;

    public void writeDecimal128IEEE754(BigDecimal value, DataOutput out)
        throws Exception
    ;

    public BigDecimal readDecimal32IEEE754(DataInput in)
        throws Exception
    ;

    public void writeDecimal32IEEE754(BigDecimal value, DataOutput out)
        throws Exception
    ;

    public BigDecimal readDecimal64IEEE754(DataInput in)
        throws Exception
    ;

    public void writeDecimal64IEEE754(BigDecimal value, DataOutput out)
        throws Exception
    ;

    public Double readDoubleIEEE754(DataInput in)
        throws Exception
    ;

    public void writeDoubleIEEE754(Double value, DataOutput out)
        throws Exception
    ;

    public Float readFloatIEEE754(DataInput in)
        throws Exception
    ;

    public void writeFloatIEEE754(Float value, DataOutput out)
        throws Exception
    ;

    public Integer readInt(DataInput in)
        throws Exception
    ;

    public void writeInt(Integer value, DataOutput out)
        throws Exception
    ;

    public Integer readIntSmallInt(DataInput in)
        throws Exception
    ;

    public void writeIntSmallInt(Integer value, DataOutput out)
        throws Exception
    ;

    public List readList0(DataInput in)
        throws Exception
    ;

    public void writeList0(List value, DataOutput out)
        throws Exception
    ;

    public List readList8(DataInput in)
        throws Exception
    ;

    public void writeList8(List value, DataOutput out)
        throws Exception
    ;

    public List readList32(DataInput in)
        throws Exception
    ;

    public void writeList32(List value, DataOutput out)
        throws Exception
    ;

    public Long readLong(DataInput in)
        throws Exception
    ;

    public void writeLong(Long value, DataOutput out)
        throws Exception
    ;

    public Long readLongSmallLong(DataInput in)
        throws Exception
    ;

    public void writeLongSmallLong(Long value, DataOutput out)
        throws Exception
    ;

    public org.fusesource.amqp.types.MapEntries readMapEntries8(DataInput in)
        throws Exception
    ;

    public void writeMapEntries8(org.fusesource.amqp.types.MapEntries value, DataOutput out)
        throws Exception
    ;

    public org.fusesource.amqp.types.MapEntries readMapEntries32(DataInput in)
        throws Exception
    ;

    public void writeMapEntries32(org.fusesource.amqp.types.MapEntries value, DataOutput out)
        throws Exception
    ;

    public Object readNull(DataInput in)
        throws Exception
    ;

    public void writeNull(DataOutput out)
        throws Exception
    ;

    public Short readShort(DataInput in)
        throws Exception
    ;

    public void writeShort(Short value, DataOutput out)
        throws Exception
    ;

    public String readStringStr8UTF8(DataInput in)
        throws Exception
    ;

    public void writeStringStr8UTF8(String value, DataOutput out)
        throws Exception
    ;

    public String readStringStr32UTF8(DataInput in)
        throws Exception
    ;

    public void writeStringStr32UTF8(String value, DataOutput out)
        throws Exception
    ;

    public Buffer readSymbolSym8(DataInput in)
        throws Exception
    ;

    public void writeSymbolSym8(Buffer value, DataOutput out)
        throws Exception
    ;

    public Buffer readSymbolSym32(DataInput in)
        throws Exception
    ;

    public void writeSymbolSym32(Buffer value, DataOutput out)
        throws Exception
    ;

    public Date readTimestampMS64(DataInput in)
        throws Exception
    ;

    public void writeTimestampMS64(Date value, DataOutput out)
        throws Exception
    ;

    public Short readUByte(DataInput in)
        throws Exception
    ;

    public void writeUByte(Short value, DataOutput out)
        throws Exception
    ;

    public Long readUInt(DataInput in)
        throws Exception
    ;

    public void writeUInt(Long value, DataOutput out)
        throws Exception
    ;

    public Long readUIntSmallUInt(DataInput in)
        throws Exception
    ;

    public void writeUIntSmallUInt(Long value, DataOutput out)
        throws Exception
    ;

    public Long readUIntUInt0(DataInput in)
        throws Exception
    ;

    public void writeUIntUInt0(Long value, DataOutput out)
        throws Exception
    ;

    public BigInteger readULong(DataInput in)
        throws Exception
    ;

    public void writeULong(BigInteger value, DataOutput out)
        throws Exception
    ;

    public BigInteger readULongSmallULong(DataInput in)
        throws Exception
    ;

    public void writeULongSmallULong(BigInteger value, DataOutput out)
        throws Exception
    ;

    public BigInteger readULongULong0(DataInput in)
        throws Exception
    ;

    public void writeULongULong0(BigInteger value, DataOutput out)
        throws Exception
    ;

    public Integer readUShort(DataInput in)
        throws Exception
    ;

    public void writeUShort(Integer value, DataOutput out)
        throws Exception
    ;

    public UUID readUUID(DataInput in)
        throws Exception
    ;

    public void writeUUID(UUID value, DataOutput out)
        throws Exception
    ;

}
