
package org.fusesource.amqp.codec.marshaller;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.fusesource.amqp.types.MapEntries;
import org.fusesource.hawtbuf.Buffer;

public interface Sizer {


    public long sizeOfArray(Object[] value);

    public long sizeOfBinary(Buffer value);

    public long sizeOfBoolean(Boolean value);

    public long sizeOfByte(Byte value);

    public long sizeOfChar(Character value);

    public long sizeOfDecimal128(BigDecimal value);

    public long sizeOfDecimal32(BigDecimal value);

    public long sizeOfDecimal64(BigDecimal value);

    public long sizeOfDouble(Double value);

    public long sizeOfFloat(Float value);

    public long sizeOfInt(Integer value);

    public long sizeOfList(List value);

    public long sizeOfLong(Long value);

    public long sizeOfMap(MapEntries value);

    public long sizeOfShort(Short value);

    public long sizeOfString(String value);

    public long sizeOfSymbol(Buffer value);

    public long sizeOfTimestamp(Date value);

    public long sizeOfUByte(Short value);

    public long sizeOfUInt(Long value);

    public long sizeOfULong(BigInteger value);

    public long sizeOfUShort(Integer value);

    public long sizeOfUUID(UUID value);

}
