
package org.fusesource.amqp.codec.marshaller;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.fusesource.amqp.types.AMQPArray;
import org.fusesource.amqp.types.AMQPBinary;
import org.fusesource.amqp.types.AMQPBoolean;
import org.fusesource.amqp.types.AMQPByte;
import org.fusesource.amqp.types.AMQPChar;
import org.fusesource.amqp.types.AMQPDecimal128;
import org.fusesource.amqp.types.AMQPDecimal32;
import org.fusesource.amqp.types.AMQPDecimal64;
import org.fusesource.amqp.types.AMQPDouble;
import org.fusesource.amqp.types.AMQPFloat;
import org.fusesource.amqp.types.AMQPInt;
import org.fusesource.amqp.types.AMQPList;
import org.fusesource.amqp.types.AMQPLong;
import org.fusesource.amqp.types.AMQPMap;
import org.fusesource.amqp.types.AMQPSequence;
import org.fusesource.amqp.types.AMQPShort;
import org.fusesource.amqp.types.AMQPString;
import org.fusesource.amqp.types.AMQPSymbol;
import org.fusesource.amqp.types.AMQPTimestamp;
import org.fusesource.amqp.types.AMQPUByte;
import org.fusesource.amqp.types.AMQPUInt;
import org.fusesource.amqp.types.AMQPULong;
import org.fusesource.amqp.types.AMQPUShort;
import org.fusesource.amqp.types.AMQPUUID;
import org.fusesource.amqp.types.AMQPValue;
import org.fusesource.amqp.types.Accepted;
import org.fusesource.amqp.types.ApplicationProperties;
import org.fusesource.amqp.types.Attach;
import org.fusesource.amqp.types.Begin;
import org.fusesource.amqp.types.Close;
import org.fusesource.amqp.types.Coordinator;
import org.fusesource.amqp.types.Data;
import org.fusesource.amqp.types.Declare;
import org.fusesource.amqp.types.Declared;
import org.fusesource.amqp.types.DeleteOnClose;
import org.fusesource.amqp.types.DeleteOnNoLinks;
import org.fusesource.amqp.types.DeleteOnNoLinksOrMessages;
import org.fusesource.amqp.types.DeleteOnNoMessages;
import org.fusesource.amqp.types.DeliveryAnnotations;
import org.fusesource.amqp.types.Detach;
import org.fusesource.amqp.types.Discharge;
import org.fusesource.amqp.types.Disposition;
import org.fusesource.amqp.types.End;
import org.fusesource.amqp.types.Error;
import org.fusesource.amqp.types.Flow;
import org.fusesource.amqp.types.Footer;
import org.fusesource.amqp.types.Header;
import org.fusesource.amqp.types.LegacyAMQPDirectBinding;
import org.fusesource.amqp.types.LegacyAMQPHeadersBinding;
import org.fusesource.amqp.types.LegacyAMQPTopicBinding;
import org.fusesource.amqp.types.MessageAnnotations;
import org.fusesource.amqp.types.Modified;
import org.fusesource.amqp.types.NoLocalFilter;
import org.fusesource.amqp.types.Open;
import org.fusesource.amqp.types.Properties;
import org.fusesource.amqp.types.Received;
import org.fusesource.amqp.types.Rejected;
import org.fusesource.amqp.types.Released;
import org.fusesource.amqp.types.SASLChallenge;
import org.fusesource.amqp.types.SASLInit;
import org.fusesource.amqp.types.SASLMechanisms;
import org.fusesource.amqp.types.SASLOutcome;
import org.fusesource.amqp.types.SASLResponse;
import org.fusesource.amqp.types.SelectorFilter;
import org.fusesource.amqp.types.Source;
import org.fusesource.amqp.types.Target;
import org.fusesource.amqp.types.TransactionalState;
import org.fusesource.amqp.types.Transfer;
import org.fusesource.hawtbuf.Buffer;

public class TypeRegistry {

    public final static byte DESCRIBED_FORMAT_CODE = (0x00);
    public final static byte NULL_FORMAT_CODE = (0x40);
    protected final static TypeRegistry SINGLETON = new TypeRegistry();
    protected final Map<Byte, Class> primitiveFormatCodeMap = new HashMap<Byte, Class>();
    protected final Map<BigInteger, Class> formatCodeMap = new HashMap<BigInteger, Class>();
    protected final Map<Buffer, Class> symbolicCodeMap = new HashMap<Buffer, Class>();
    protected final static EncodingPicker PICKER = (AMQPEncodingPicker.instance());
    protected final static Sizer SIZER = (AMQPSizer.instance());
    protected final static PrimitiveEncoder ENCODER = (Encoder.instance());

    static {
        new AMQPArray();
        new AMQPBinary();
        new AMQPBoolean();
        new AMQPByte();
        new AMQPChar();
        new AMQPDecimal128();
        new AMQPDecimal32();
        new AMQPDecimal64();
        new AMQPDouble();
        new AMQPFloat();
        new AMQPInt();
        new AMQPList();
        new AMQPLong();
        new AMQPMap();
        new AMQPShort();
        new AMQPString();
        new AMQPSymbol();
        new AMQPTimestamp();
        new AMQPUByte();
        new AMQPUInt();
        new AMQPULong();
        new AMQPUShort();
        new AMQPUUID();
        new Accepted();
        new AMQPSequence();
        new AMQPValue();
        new ApplicationProperties();
        new Attach();
        new Begin();
        new Close();
        new Coordinator();
        new Data();
        new Declare();
        new Declared();
        new DeleteOnClose();
        new DeleteOnNoLinks();
        new DeleteOnNoLinksOrMessages();
        new DeleteOnNoMessages();
        new DeliveryAnnotations();
        new Detach();
        new Discharge();
        new Disposition();
        new End();
        new Error();
        new Flow();
        new Footer();
        new Header();
        new LegacyAMQPDirectBinding();
        new LegacyAMQPHeadersBinding();
        new LegacyAMQPTopicBinding();
        new MessageAnnotations();
        new Modified();
        new NoLocalFilter();
        new Open();
        new Properties();
        new Received();
        new Rejected();
        new Released();
        new SASLChallenge();
        new SASLInit();
        new SASLMechanisms();
        new SASLOutcome();
        new SASLResponse();
        new SelectorFilter();
        new Source();
        new Target();
        new TransactionalState();
        new Transfer();
    }

    public static TypeRegistry instance() {
        return SINGLETON;
    }

    public Map<BigInteger, Class> getFormatCodeMap() {
        return formatCodeMap;
    }

    public Map<Buffer, Class> getSymbolicCodeMap() {
        return symbolicCodeMap;
    }

    public Map<Byte, Class> getPrimitiveFormatCodeMap() {
        return primitiveFormatCodeMap;
    }

    public EncodingPicker picker() {
        return PICKER;
    }

    public Sizer sizer() {
        return SIZER;
    }

    public PrimitiveEncoder encoder() {
        return ENCODER;
    }

}
