
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPArray
    implements AMQPType
{

    protected java.lang.Object[] value;
    public final static byte ARRAY_ARRAY8_CODE = ((byte)0xe0);
    public final static int ARRAY_ARRAY8_WIDTH = 1;
    public final static byte ARRAY_ARRAY32_CODE = ((byte)0xf0);
    public final static int ARRAY_ARRAY32_WIDTH = 4;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(ARRAY_ARRAY8_CODE, AMQPArray.class);
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(ARRAY_ARRAY32_CODE, AMQPArray.class);
    }

    public AMQPArray() {
        this.value = null;
    }

    public AMQPArray(java.lang.Object[] value) {
        this.value = value;
    }

    public java.lang.Object[] getValue() {
        return this.value;
    }

    public void setValue(java.lang.Object[] value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfArray(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPArray))) {
            return false;
        }
        return this.equals(((AMQPArray) other));
    }

    public boolean equals(AMQPArray other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPArray.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return Arrays.toString(this.value);
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPArray.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPArray.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPArray.writeBody(formatCode, this.value, out);
    }

    public static void write(java.lang.Object[] value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPArray.writeConstructor(value, out);
        AMQPArray.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(java.lang.Object[] value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseArrayEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, java.lang.Object[] value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case ARRAY_ARRAY8_CODE:
                TypeRegistry.instance().encoder().writeArray8(value, out);
                break;
            case ARRAY_ARRAY32_CODE:
                TypeRegistry.instance().encoder().writeArray32(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for array : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static java.lang.Object[] read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((java.lang.Object[]) TypeRegistry.instance().encoder().readNull(in));
            case ARRAY_ARRAY8_CODE:
                return TypeRegistry.instance().encoder().readArray8(in);
            case ARRAY_ARRAY32_CODE:
                return TypeRegistry.instance().encoder().readArray32(in);
            default:
                throw new Exception(("Unknown format code for array : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case ARRAY_ARRAY8_CODE:
                this.value = TypeRegistry.instance().encoder().readArray8(in);
                break;
            case ARRAY_ARRAY32_CODE:
                this.value = TypeRegistry.instance().encoder().readArray32(in);
                break;
            default:
                throw new Exception(("Unknown format code for array : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return ARRAY_ARRAY32_CODE;
    }

}
