
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.Buffer;

public class AMQPBinary
    implements AMQPType
{

    protected Buffer value;
    public final static byte BINARY_VBIN8_CODE = ((byte)0xa0);
    public final static int BINARY_VBIN8_WIDTH = 1;
    public final static byte BINARY_VBIN32_CODE = ((byte)0xb0);
    public final static int BINARY_VBIN32_WIDTH = 4;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(BINARY_VBIN8_CODE, AMQPBinary.class);
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(BINARY_VBIN32_CODE, AMQPBinary.class);
    }

    public AMQPBinary() {
        this.value = null;
    }

    public AMQPBinary(Buffer value) {
        this.value = value;
    }

    public Buffer getValue() {
        return this.value;
    }

    public void setValue(Buffer value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfBinary(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPBinary))) {
            return false;
        }
        return this.equals(((AMQPBinary) other));
    }

    public boolean equals(AMQPBinary other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPBinary.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPBinary.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPBinary.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPBinary.writeBody(formatCode, this.value, out);
    }

    public static void write(Buffer value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPBinary.writeConstructor(value, out);
        AMQPBinary.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(Buffer value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseBinaryEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, Buffer value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case BINARY_VBIN8_CODE:
                TypeRegistry.instance().encoder().writeBinaryVBIN8(value, out);
                break;
            case BINARY_VBIN32_CODE:
                TypeRegistry.instance().encoder().writeBinaryVBIN32(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for binary : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static Buffer read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((Buffer) TypeRegistry.instance().encoder().readNull(in));
            case BINARY_VBIN8_CODE:
                return TypeRegistry.instance().encoder().readBinaryVBIN8(in);
            case BINARY_VBIN32_CODE:
                return TypeRegistry.instance().encoder().readBinaryVBIN32(in);
            default:
                throw new Exception(("Unknown format code for binary : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case BINARY_VBIN8_CODE:
                this.value = TypeRegistry.instance().encoder().readBinaryVBIN8(in);
                break;
            case BINARY_VBIN32_CODE:
                this.value = TypeRegistry.instance().encoder().readBinaryVBIN32(in);
                break;
            default:
                throw new Exception(("Unknown format code for binary : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return BINARY_VBIN32_CODE;
    }

}
