
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPBoolean
    implements AMQPType
{

    protected Boolean value;
    public final static byte BOOLEAN_CODE = ((byte)0x56);
    public final static int BOOLEAN_WIDTH = 1;
    public final static byte BOOLEAN_TRUE_CODE = ((byte)0x41);
    public final static int BOOLEAN_TRUE_WIDTH = 0;
    public final static byte BOOLEAN_FALSE_CODE = ((byte)0x42);
    public final static int BOOLEAN_FALSE_WIDTH = 0;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(BOOLEAN_CODE, AMQPBoolean.class);
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(BOOLEAN_TRUE_CODE, AMQPBoolean.class);
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(BOOLEAN_FALSE_CODE, AMQPBoolean.class);
    }

    public AMQPBoolean() {
        this.value = null;
    }

    public AMQPBoolean(Boolean value) {
        this.value = value;
    }

    public Boolean getValue() {
        return this.value;
    }

    public void setValue(Boolean value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfBoolean(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPBoolean))) {
            return false;
        }
        return this.equals(((AMQPBoolean) other));
    }

    public boolean equals(AMQPBoolean other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPBoolean.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPBoolean.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPBoolean.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPBoolean.writeBody(formatCode, this.value, out);
    }

    public static void write(Boolean value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPBoolean.writeConstructor(value, out);
        AMQPBoolean.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(Boolean value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseBooleanEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, Boolean value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case BOOLEAN_CODE:
                TypeRegistry.instance().encoder().writeBoolean(value, out);
                break;
            case BOOLEAN_TRUE_CODE:
                TypeRegistry.instance().encoder().writeBooleanTrue(value, out);
                break;
            case BOOLEAN_FALSE_CODE:
                TypeRegistry.instance().encoder().writeBooleanFalse(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for boolean : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static Boolean read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((Boolean) TypeRegistry.instance().encoder().readNull(in));
            case BOOLEAN_CODE:
                return TypeRegistry.instance().encoder().readBoolean(in);
            case BOOLEAN_TRUE_CODE:
                return TypeRegistry.instance().encoder().readBooleanTrue(in);
            case BOOLEAN_FALSE_CODE:
                return TypeRegistry.instance().encoder().readBooleanFalse(in);
            default:
                throw new Exception(("Unknown format code for boolean : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case BOOLEAN_CODE:
                this.value = TypeRegistry.instance().encoder().readBoolean(in);
                break;
            case BOOLEAN_TRUE_CODE:
                this.value = TypeRegistry.instance().encoder().readBooleanTrue(in);
                break;
            case BOOLEAN_FALSE_CODE:
                this.value = TypeRegistry.instance().encoder().readBooleanFalse(in);
                break;
            default:
                throw new Exception(("Unknown format code for boolean : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return BOOLEAN_CODE;
    }

}
