
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPByte
    implements AMQPType
{

    protected Byte value;
    public final static byte BYTE_CODE = ((byte)0x51);
    public final static int BYTE_WIDTH = 1;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(BYTE_CODE, AMQPByte.class);
    }

    public AMQPByte() {
        this.value = null;
    }

    public AMQPByte(Byte value) {
        this.value = value;
    }

    public Byte getValue() {
        return this.value;
    }

    public void setValue(Byte value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfByte(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPByte))) {
            return false;
        }
        return this.equals(((AMQPByte) other));
    }

    public boolean equals(AMQPByte other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPByte.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPByte.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPByte.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPByte.writeBody(formatCode, this.value, out);
    }

    public static void write(Byte value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPByte.writeConstructor(value, out);
        AMQPByte.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(Byte value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseByteEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, Byte value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case BYTE_CODE:
                TypeRegistry.instance().encoder().writeByte(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for byte : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static Byte read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((Byte) TypeRegistry.instance().encoder().readNull(in));
            case BYTE_CODE:
                return TypeRegistry.instance().encoder().readByte(in);
            default:
                throw new Exception(("Unknown format code for byte : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case BYTE_CODE:
                this.value = TypeRegistry.instance().encoder().readByte(in);
                break;
            default:
                throw new Exception(("Unknown format code for byte : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return BYTE_CODE;
    }

}
