
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPChar
    implements AMQPType
{

    protected Character value;
    public final static byte CHAR_UTF32_CODE = ((byte)0x73);
    public final static int CHAR_UTF32_WIDTH = 4;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(CHAR_UTF32_CODE, AMQPChar.class);
    }

    public AMQPChar() {
        this.value = null;
    }

    public AMQPChar(Character value) {
        this.value = value;
    }

    public Character getValue() {
        return this.value;
    }

    public void setValue(Character value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfChar(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPChar))) {
            return false;
        }
        return this.equals(((AMQPChar) other));
    }

    public boolean equals(AMQPChar other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPChar.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPChar.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPChar.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPChar.writeBody(formatCode, this.value, out);
    }

    public static void write(Character value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPChar.writeConstructor(value, out);
        AMQPChar.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(Character value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseCharEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, Character value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case CHAR_UTF32_CODE:
                TypeRegistry.instance().encoder().writeCharUTF32(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for char : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static Character read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((Character) TypeRegistry.instance().encoder().readNull(in));
            case CHAR_UTF32_CODE:
                return TypeRegistry.instance().encoder().readCharUTF32(in);
            default:
                throw new Exception(("Unknown format code for char : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case CHAR_UTF32_CODE:
                this.value = TypeRegistry.instance().encoder().readCharUTF32(in);
                break;
            default:
                throw new Exception(("Unknown format code for char : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return CHAR_UTF32_CODE;
    }

}
