
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigDecimal;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPDecimal32
    implements AMQPType
{

    protected BigDecimal value;
    public final static byte DECIMAL32_IEEE_754_CODE = ((byte)0x74);
    public final static int DECIMAL32_IEEE_754_WIDTH = 4;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(DECIMAL32_IEEE_754_CODE, AMQPDecimal32 .class);
    }

    public AMQPDecimal32() {
        this.value = null;
    }

    public AMQPDecimal32(BigDecimal value) {
        this.value = value;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfDecimal32(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPDecimal32))) {
            return false;
        }
        return this.equals(((AMQPDecimal32) other));
    }

    public boolean equals(AMQPDecimal32 other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPDecimal32 .class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPDecimal32 .write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPDecimal32 .writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPDecimal32 .writeBody(formatCode, this.value, out);
    }

    public static void write(BigDecimal value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPDecimal32 .writeConstructor(value, out);
        AMQPDecimal32 .writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(BigDecimal value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseDecimal32Encoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, BigDecimal value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case DECIMAL32_IEEE_754_CODE:
                TypeRegistry.instance().encoder().writeDecimal32IEEE754(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for decimal32 : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static BigDecimal read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((BigDecimal) TypeRegistry.instance().encoder().readNull(in));
            case DECIMAL32_IEEE_754_CODE:
                return TypeRegistry.instance().encoder().readDecimal32IEEE754(in);
            default:
                throw new Exception(("Unknown format code for decimal32 : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case DECIMAL32_IEEE_754_CODE:
                this.value = TypeRegistry.instance().encoder().readDecimal32IEEE754(in);
                break;
            default:
                throw new Exception(("Unknown format code for decimal32 : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return DECIMAL32_IEEE_754_CODE;
    }

}
