
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigDecimal;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPDecimal64
    implements AMQPType
{

    protected BigDecimal value;
    public final static byte DECIMAL64_IEEE_754_CODE = ((byte)0x84);
    public final static int DECIMAL64_IEEE_754_WIDTH = 8;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(DECIMAL64_IEEE_754_CODE, AMQPDecimal64 .class);
    }

    public AMQPDecimal64() {
        this.value = null;
    }

    public AMQPDecimal64(BigDecimal value) {
        this.value = value;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfDecimal64(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPDecimal64))) {
            return false;
        }
        return this.equals(((AMQPDecimal64) other));
    }

    public boolean equals(AMQPDecimal64 other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPDecimal64 .class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPDecimal64 .write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPDecimal64 .writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPDecimal64 .writeBody(formatCode, this.value, out);
    }

    public static void write(BigDecimal value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPDecimal64 .writeConstructor(value, out);
        AMQPDecimal64 .writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(BigDecimal value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseDecimal64Encoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, BigDecimal value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case DECIMAL64_IEEE_754_CODE:
                TypeRegistry.instance().encoder().writeDecimal64IEEE754(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for decimal64 : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static BigDecimal read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((BigDecimal) TypeRegistry.instance().encoder().readNull(in));
            case DECIMAL64_IEEE_754_CODE:
                return TypeRegistry.instance().encoder().readDecimal64IEEE754(in);
            default:
                throw new Exception(("Unknown format code for decimal64 : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case DECIMAL64_IEEE_754_CODE:
                this.value = TypeRegistry.instance().encoder().readDecimal64IEEE754(in);
                break;
            default:
                throw new Exception(("Unknown format code for decimal64 : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return DECIMAL64_IEEE_754_CODE;
    }

}
