
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPDouble
    implements AMQPType
{

    protected Double value;
    public final static byte DOUBLE_IEEE_754_CODE = ((byte)0x82);
    public final static int DOUBLE_IEEE_754_WIDTH = 8;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(DOUBLE_IEEE_754_CODE, AMQPDouble.class);
    }

    public AMQPDouble() {
        this.value = null;
    }

    public AMQPDouble(Double value) {
        this.value = value;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfDouble(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPDouble))) {
            return false;
        }
        return this.equals(((AMQPDouble) other));
    }

    public boolean equals(AMQPDouble other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPDouble.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPDouble.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPDouble.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPDouble.writeBody(formatCode, this.value, out);
    }

    public static void write(Double value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPDouble.writeConstructor(value, out);
        AMQPDouble.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(Double value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseDoubleEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, Double value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case DOUBLE_IEEE_754_CODE:
                TypeRegistry.instance().encoder().writeDoubleIEEE754(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for double : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static Double read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((Double) TypeRegistry.instance().encoder().readNull(in));
            case DOUBLE_IEEE_754_CODE:
                return TypeRegistry.instance().encoder().readDoubleIEEE754(in);
            default:
                throw new Exception(("Unknown format code for double : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case DOUBLE_IEEE_754_CODE:
                this.value = TypeRegistry.instance().encoder().readDoubleIEEE754(in);
                break;
            default:
                throw new Exception(("Unknown format code for double : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return DOUBLE_IEEE_754_CODE;
    }

}
