
package org.fusesource.amqp.types;

import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class AMQPError
    extends AMQPSymbol
    implements AMQPErrorCondition
{

    public final static AMQPError INTERNAL_ERROR = new AMQPError(new AsciiBuffer("amqp:internal-error"));
    public final static AMQPError NOT_FOUND = new AMQPError(new AsciiBuffer("amqp:not-found"));
    public final static AMQPError UNAUTHORIZED_ACCESS = new AMQPError(new AsciiBuffer("amqp:unauthorized-access"));
    public final static AMQPError DECODE_ERROR = new AMQPError(new AsciiBuffer("amqp:decode-error"));
    public final static AMQPError RESOURCE_LIMIT_EXCEEDED = new AMQPError(new AsciiBuffer("amqp:resource-limit-exceeded"));
    public final static AMQPError NOT_ALLOWED = new AMQPError(new AsciiBuffer("amqp:not-allowed"));
    public final static AMQPError INVALID_FIELD = new AMQPError(new AsciiBuffer("amqp:invalid-field"));
    public final static AMQPError NOT_IMPLEMENTED = new AMQPError(new AsciiBuffer("amqp:not-implemented"));
    public final static AMQPError RESOURCE_LOCKED = new AMQPError(new AsciiBuffer("amqp:resource-locked"));
    public final static AMQPError PRECONDITION_FAILED = new AMQPError(new AsciiBuffer("amqp:precondition-failed"));
    public final static AMQPError RESOURCE_DELETED = new AMQPError(new AsciiBuffer("amqp:resource-deleted"));
    public final static AMQPError ILLEGAL_STATE = new AMQPError(new AsciiBuffer("amqp:illegal-state"));
    public final static AMQPError FRAME_SIZE_TOO_SMALL = new AMQPError(new AsciiBuffer("amqp:frame-size-too-small"));

    public AMQPError() {
    }

    public AMQPError(Buffer value) {
        this.value = value;
    }

    public static AMQPError valueOf(Buffer value) {
        if (value == null) {
            return null;
        }
        if (value == INTERNAL_ERROR.getValue()) {
            return INTERNAL_ERROR;
        }
        if (value == NOT_FOUND.getValue()) {
            return NOT_FOUND;
        }
        if (value == UNAUTHORIZED_ACCESS.getValue()) {
            return UNAUTHORIZED_ACCESS;
        }
        if (value == DECODE_ERROR.getValue()) {
            return DECODE_ERROR;
        }
        if (value == RESOURCE_LIMIT_EXCEEDED.getValue()) {
            return RESOURCE_LIMIT_EXCEEDED;
        }
        if (value == NOT_ALLOWED.getValue()) {
            return NOT_ALLOWED;
        }
        if (value == INVALID_FIELD.getValue()) {
            return INVALID_FIELD;
        }
        if (value == NOT_IMPLEMENTED.getValue()) {
            return NOT_IMPLEMENTED;
        }
        if (value == RESOURCE_LOCKED.getValue()) {
            return RESOURCE_LOCKED;
        }
        if (value == PRECONDITION_FAILED.getValue()) {
            return PRECONDITION_FAILED;
        }
        if (value == RESOURCE_DELETED.getValue()) {
            return RESOURCE_DELETED;
        }
        if (value == ILLEGAL_STATE.getValue()) {
            return ILLEGAL_STATE;
        }
        if (value == FRAME_SIZE_TOO_SMALL.getValue()) {
            return FRAME_SIZE_TOO_SMALL;
        }
        throw new IllegalArgumentException(("invalid AMQPError value: "+ value));
    }

}
