
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPFloat
    implements AMQPType
{

    protected Float value;
    public final static byte FLOAT_IEEE_754_CODE = ((byte)0x72);
    public final static int FLOAT_IEEE_754_WIDTH = 4;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(FLOAT_IEEE_754_CODE, AMQPFloat.class);
    }

    public AMQPFloat() {
        this.value = null;
    }

    public AMQPFloat(Float value) {
        this.value = value;
    }

    public Float getValue() {
        return this.value;
    }

    public void setValue(Float value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfFloat(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPFloat))) {
            return false;
        }
        return this.equals(((AMQPFloat) other));
    }

    public boolean equals(AMQPFloat other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPFloat.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPFloat.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPFloat.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPFloat.writeBody(formatCode, this.value, out);
    }

    public static void write(Float value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPFloat.writeConstructor(value, out);
        AMQPFloat.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(Float value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseFloatEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, Float value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case FLOAT_IEEE_754_CODE:
                TypeRegistry.instance().encoder().writeFloatIEEE754(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for float : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static Float read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((Float) TypeRegistry.instance().encoder().readNull(in));
            case FLOAT_IEEE_754_CODE:
                return TypeRegistry.instance().encoder().readFloatIEEE754(in);
            default:
                throw new Exception(("Unknown format code for float : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case FLOAT_IEEE_754_CODE:
                this.value = TypeRegistry.instance().encoder().readFloatIEEE754(in);
                break;
            default:
                throw new Exception(("Unknown format code for float : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return FLOAT_IEEE_754_CODE;
    }

}
