
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPInt
    implements AMQPType
{

    protected Integer value;
    public final static byte INT_CODE = ((byte)0x71);
    public final static int INT_WIDTH = 4;
    public final static byte INT_SMALLINT_CODE = ((byte)0x54);
    public final static int INT_SMALLINT_WIDTH = 1;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(INT_CODE, AMQPInt.class);
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(INT_SMALLINT_CODE, AMQPInt.class);
    }

    public AMQPInt() {
        this.value = null;
    }

    public AMQPInt(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfInt(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPInt))) {
            return false;
        }
        return this.equals(((AMQPInt) other));
    }

    public boolean equals(AMQPInt other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPInt.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPInt.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPInt.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPInt.writeBody(formatCode, this.value, out);
    }

    public static void write(Integer value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPInt.writeConstructor(value, out);
        AMQPInt.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(Integer value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseIntEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, Integer value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case INT_CODE:
                TypeRegistry.instance().encoder().writeInt(value, out);
                break;
            case INT_SMALLINT_CODE:
                TypeRegistry.instance().encoder().writeIntSmallInt(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for int : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static Integer read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((Integer) TypeRegistry.instance().encoder().readNull(in));
            case INT_CODE:
                return TypeRegistry.instance().encoder().readInt(in);
            case INT_SMALLINT_CODE:
                return TypeRegistry.instance().encoder().readIntSmallInt(in);
            default:
                throw new Exception(("Unknown format code for int : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case INT_CODE:
                this.value = TypeRegistry.instance().encoder().readInt(in);
                break;
            case INT_SMALLINT_CODE:
                this.value = TypeRegistry.instance().encoder().readIntSmallInt(in);
                break;
            default:
                throw new Exception(("Unknown format code for int : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return INT_CODE;
    }

}
