
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.List;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPList
    implements AMQPType
{

    protected List value;
    public final static byte LIST_LIST0_CODE = ((byte)0x45);
    public final static int LIST_LIST0_WIDTH = 0;
    public final static byte LIST_LIST8_CODE = ((byte)0xc0);
    public final static int LIST_LIST8_WIDTH = 1;
    public final static byte LIST_LIST32_CODE = ((byte)0xd0);
    public final static int LIST_LIST32_WIDTH = 4;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(LIST_LIST0_CODE, AMQPList.class);
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(LIST_LIST8_CODE, AMQPList.class);
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(LIST_LIST32_CODE, AMQPList.class);
    }

    public AMQPList() {
        this.value = null;
    }

    public AMQPList(List value) {
        this.value = value;
    }

    public List getValue() {
        return this.value;
    }

    public void setValue(List value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfList(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPList))) {
            return false;
        }
        return this.equals(((AMQPList) other));
    }

    public boolean equals(AMQPList other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPList.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPList.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPList.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPList.writeBody(formatCode, this.value, out);
    }

    public static void write(List value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPList.writeConstructor(value, out);
        AMQPList.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(List value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseListEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, List value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case LIST_LIST0_CODE:
                TypeRegistry.instance().encoder().writeList0(value, out);
                break;
            case LIST_LIST8_CODE:
                TypeRegistry.instance().encoder().writeList8(value, out);
                break;
            case LIST_LIST32_CODE:
                TypeRegistry.instance().encoder().writeList32(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for list : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static List read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((List) TypeRegistry.instance().encoder().readNull(in));
            case LIST_LIST0_CODE:
                return TypeRegistry.instance().encoder().readList0(in);
            case LIST_LIST8_CODE:
                return TypeRegistry.instance().encoder().readList8(in);
            case LIST_LIST32_CODE:
                return TypeRegistry.instance().encoder().readList32(in);
            default:
                throw new Exception(("Unknown format code for list : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case LIST_LIST0_CODE:
                this.value = TypeRegistry.instance().encoder().readList0(in);
                break;
            case LIST_LIST8_CODE:
                this.value = TypeRegistry.instance().encoder().readList8(in);
                break;
            case LIST_LIST32_CODE:
                this.value = TypeRegistry.instance().encoder().readList32(in);
                break;
            default:
                throw new Exception(("Unknown format code for list : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return LIST_LIST32_CODE;
    }

}
