
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPLong
    implements AMQPType
{

    protected Long value;
    public final static byte LONG_CODE = ((byte)0x81);
    public final static int LONG_WIDTH = 8;
    public final static byte LONG_SMALLLONG_CODE = ((byte)0x55);
    public final static int LONG_SMALLLONG_WIDTH = 1;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(LONG_CODE, AMQPLong.class);
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(LONG_SMALLLONG_CODE, AMQPLong.class);
    }

    public AMQPLong() {
        this.value = null;
    }

    public AMQPLong(Long value) {
        this.value = value;
    }

    public Long getValue() {
        return this.value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfLong(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPLong))) {
            return false;
        }
        return this.equals(((AMQPLong) other));
    }

    public boolean equals(AMQPLong other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPLong.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPLong.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPLong.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPLong.writeBody(formatCode, this.value, out);
    }

    public static void write(Long value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPLong.writeConstructor(value, out);
        AMQPLong.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(Long value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseLongEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, Long value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case LONG_CODE:
                TypeRegistry.instance().encoder().writeLong(value, out);
                break;
            case LONG_SMALLLONG_CODE:
                TypeRegistry.instance().encoder().writeLongSmallLong(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for long : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static Long read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((Long) TypeRegistry.instance().encoder().readNull(in));
            case LONG_CODE:
                return TypeRegistry.instance().encoder().readLong(in);
            case LONG_SMALLLONG_CODE:
                return TypeRegistry.instance().encoder().readLongSmallLong(in);
            default:
                throw new Exception(("Unknown format code for long : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case LONG_CODE:
                this.value = TypeRegistry.instance().encoder().readLong(in);
                break;
            case LONG_SMALLLONG_CODE:
                this.value = TypeRegistry.instance().encoder().readLongSmallLong(in);
                break;
            default:
                throw new Exception(("Unknown format code for long : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return LONG_CODE;
    }

}
