
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPMap
    implements AMQPType
{

    protected org.fusesource.amqp.types.MapEntries value;
    public final static byte MAP_MAP8_CODE = ((byte)0xc1);
    public final static int MAP_MAP8_WIDTH = 1;
    public final static byte MAP_MAP32_CODE = ((byte)0xd1);
    public final static int MAP_MAP32_WIDTH = 4;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(MAP_MAP8_CODE, AMQPMap.class);
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(MAP_MAP32_CODE, AMQPMap.class);
    }

    public AMQPMap() {
        this.value = null;
    }

    public AMQPMap(org.fusesource.amqp.types.MapEntries value) {
        this.value = value;
    }

    public org.fusesource.amqp.types.MapEntries getValue() {
        return this.value;
    }

    public void setValue(org.fusesource.amqp.types.MapEntries value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfMap(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPMap))) {
            return false;
        }
        return this.equals(((AMQPMap) other));
    }

    public boolean equals(AMQPMap other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPMap.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPMap.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPMap.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPMap.writeBody(formatCode, this.value, out);
    }

    public static void write(org.fusesource.amqp.types.MapEntries value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPMap.writeConstructor(value, out);
        AMQPMap.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(org.fusesource.amqp.types.MapEntries value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseMapEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, org.fusesource.amqp.types.MapEntries value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case MAP_MAP8_CODE:
                TypeRegistry.instance().encoder().writeMapEntries8(value, out);
                break;
            case MAP_MAP32_CODE:
                TypeRegistry.instance().encoder().writeMapEntries32(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for map : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static org.fusesource.amqp.types.MapEntries read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((org.fusesource.amqp.types.MapEntries) TypeRegistry.instance().encoder().readNull(in));
            case MAP_MAP8_CODE:
                return TypeRegistry.instance().encoder().readMapEntries8(in);
            case MAP_MAP32_CODE:
                return TypeRegistry.instance().encoder().readMapEntries32(in);
            default:
                throw new Exception(("Unknown format code for map : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case MAP_MAP8_CODE:
                this.value = TypeRegistry.instance().encoder().readMapEntries8(in);
                break;
            case MAP_MAP32_CODE:
                this.value = TypeRegistry.instance().encoder().readMapEntries32(in);
                break;
            default:
                throw new Exception(("Unknown format code for map : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return MAP_MAP32_CODE;
    }

}
