
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPShort
    implements AMQPType
{

    protected Short value;
    public final static byte SHORT_CODE = ((byte)0x61);
    public final static int SHORT_WIDTH = 2;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(SHORT_CODE, AMQPShort.class);
    }

    public AMQPShort() {
        this.value = null;
    }

    public AMQPShort(Short value) {
        this.value = value;
    }

    public Short getValue() {
        return this.value;
    }

    public void setValue(Short value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfShort(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPShort))) {
            return false;
        }
        return this.equals(((AMQPShort) other));
    }

    public boolean equals(AMQPShort other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPShort.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPShort.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPShort.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPShort.writeBody(formatCode, this.value, out);
    }

    public static void write(Short value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPShort.writeConstructor(value, out);
        AMQPShort.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(Short value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseShortEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, Short value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case SHORT_CODE:
                TypeRegistry.instance().encoder().writeShort(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for short : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static Short read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((Short) TypeRegistry.instance().encoder().readNull(in));
            case SHORT_CODE:
                return TypeRegistry.instance().encoder().readShort(in);
            default:
                throw new Exception(("Unknown format code for short : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case SHORT_CODE:
                this.value = TypeRegistry.instance().encoder().readShort(in);
                break;
            default:
                throw new Exception(("Unknown format code for short : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return SHORT_CODE;
    }

}
