
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.Buffer;

public class AMQPSymbol
    implements AMQPType
{

    protected Buffer value;
    public final static byte SYMBOL_SYM8_CODE = ((byte)0xa3);
    public final static int SYMBOL_SYM8_WIDTH = 1;
    public final static byte SYMBOL_SYM32_CODE = ((byte)0xb3);
    public final static int SYMBOL_SYM32_WIDTH = 4;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(SYMBOL_SYM8_CODE, AMQPSymbol.class);
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(SYMBOL_SYM32_CODE, AMQPSymbol.class);
    }

    public AMQPSymbol() {
        this.value = null;
    }

    public AMQPSymbol(Buffer value) {
        this.value = value;
    }

    public Buffer getValue() {
        return this.value;
    }

    public void setValue(Buffer value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfSymbol(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPSymbol))) {
            return false;
        }
        return this.equals(((AMQPSymbol) other));
    }

    public boolean equals(AMQPSymbol other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPSymbol.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPSymbol.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPSymbol.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPSymbol.writeBody(formatCode, this.value, out);
    }

    public static void write(Buffer value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPSymbol.writeConstructor(value, out);
        AMQPSymbol.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(Buffer value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseSymbolEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, Buffer value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case SYMBOL_SYM8_CODE:
                TypeRegistry.instance().encoder().writeSymbolSym8(value, out);
                break;
            case SYMBOL_SYM32_CODE:
                TypeRegistry.instance().encoder().writeSymbolSym32(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for symbol : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static Buffer read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((Buffer) TypeRegistry.instance().encoder().readNull(in));
            case SYMBOL_SYM8_CODE:
                return TypeRegistry.instance().encoder().readSymbolSym8(in);
            case SYMBOL_SYM32_CODE:
                return TypeRegistry.instance().encoder().readSymbolSym32(in);
            default:
                throw new Exception(("Unknown format code for symbol : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case SYMBOL_SYM8_CODE:
                this.value = TypeRegistry.instance().encoder().readSymbolSym8(in);
                break;
            case SYMBOL_SYM32_CODE:
                this.value = TypeRegistry.instance().encoder().readSymbolSym32(in);
                break;
            default:
                throw new Exception(("Unknown format code for symbol : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return SYMBOL_SYM32_CODE;
    }

}
