
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Date;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPTimestamp
    implements AMQPType
{

    protected Date value;
    public final static byte TIMESTAMP_MS64_CODE = ((byte)0x83);
    public final static int TIMESTAMP_MS64_WIDTH = 8;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(TIMESTAMP_MS64_CODE, AMQPTimestamp.class);
    }

    public AMQPTimestamp() {
        this.value = null;
    }

    public AMQPTimestamp(Date value) {
        this.value = value;
    }

    public Date getValue() {
        return this.value;
    }

    public void setValue(Date value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfTimestamp(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPTimestamp))) {
            return false;
        }
        return this.equals(((AMQPTimestamp) other));
    }

    public boolean equals(AMQPTimestamp other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPTimestamp.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPTimestamp.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPTimestamp.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPTimestamp.writeBody(formatCode, this.value, out);
    }

    public static void write(Date value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPTimestamp.writeConstructor(value, out);
        AMQPTimestamp.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(Date value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseTimestampEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, Date value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case TIMESTAMP_MS64_CODE:
                TypeRegistry.instance().encoder().writeTimestampMS64(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for timestamp : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static Date read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((Date) TypeRegistry.instance().encoder().readNull(in));
            case TIMESTAMP_MS64_CODE:
                return TypeRegistry.instance().encoder().readTimestampMS64(in);
            default:
                throw new Exception(("Unknown format code for timestamp : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case TIMESTAMP_MS64_CODE:
                this.value = TypeRegistry.instance().encoder().readTimestampMS64(in);
                break;
            default:
                throw new Exception(("Unknown format code for timestamp : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return TIMESTAMP_MS64_CODE;
    }

}
