
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPUByte
    implements AMQPType
{

    protected Short value;
    public final static byte UBYTE_CODE = ((byte)0x50);
    public final static int UBYTE_WIDTH = 1;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(UBYTE_CODE, AMQPUByte.class);
    }

    public AMQPUByte() {
        this.value = null;
    }

    public AMQPUByte(Short value) {
        this.value = value;
    }

    public Short getValue() {
        return this.value;
    }

    public void setValue(Short value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfUByte(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPUByte))) {
            return false;
        }
        return this.equals(((AMQPUByte) other));
    }

    public boolean equals(AMQPUByte other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPUByte.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPUByte.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPUByte.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPUByte.writeBody(formatCode, this.value, out);
    }

    public static void write(Short value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPUByte.writeConstructor(value, out);
        AMQPUByte.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(Short value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseUByteEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, Short value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case UBYTE_CODE:
                TypeRegistry.instance().encoder().writeUByte(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for ubyte : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static Short read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((Short) TypeRegistry.instance().encoder().readNull(in));
            case UBYTE_CODE:
                return TypeRegistry.instance().encoder().readUByte(in);
            default:
                throw new Exception(("Unknown format code for ubyte : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case UBYTE_CODE:
                this.value = TypeRegistry.instance().encoder().readUByte(in);
                break;
            default:
                throw new Exception(("Unknown format code for ubyte : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return UBYTE_CODE;
    }

}
