
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPUInt
    implements AMQPType
{

    protected Long value;
    public final static byte UINT_CODE = ((byte)0x70);
    public final static int UINT_WIDTH = 4;
    public final static byte UINT_SMALLUINT_CODE = ((byte)0x52);
    public final static int UINT_SMALLUINT_WIDTH = 1;
    public final static byte UINT_UINT0_CODE = ((byte)0x43);
    public final static int UINT_UINT0_WIDTH = 0;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(UINT_CODE, AMQPUInt.class);
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(UINT_SMALLUINT_CODE, AMQPUInt.class);
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(UINT_UINT0_CODE, AMQPUInt.class);
    }

    public AMQPUInt() {
        this.value = null;
    }

    public AMQPUInt(Long value) {
        this.value = value;
    }

    public Long getValue() {
        return this.value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfUInt(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPUInt))) {
            return false;
        }
        return this.equals(((AMQPUInt) other));
    }

    public boolean equals(AMQPUInt other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPUInt.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPUInt.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPUInt.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPUInt.writeBody(formatCode, this.value, out);
    }

    public static void write(Long value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPUInt.writeConstructor(value, out);
        AMQPUInt.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(Long value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseUIntEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, Long value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case UINT_CODE:
                TypeRegistry.instance().encoder().writeUInt(value, out);
                break;
            case UINT_SMALLUINT_CODE:
                TypeRegistry.instance().encoder().writeUIntSmallUInt(value, out);
                break;
            case UINT_UINT0_CODE:
                TypeRegistry.instance().encoder().writeUIntUInt0(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for uint : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static Long read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((Long) TypeRegistry.instance().encoder().readNull(in));
            case UINT_CODE:
                return TypeRegistry.instance().encoder().readUInt(in);
            case UINT_SMALLUINT_CODE:
                return TypeRegistry.instance().encoder().readUIntSmallUInt(in);
            case UINT_UINT0_CODE:
                return TypeRegistry.instance().encoder().readUIntUInt0(in);
            default:
                throw new Exception(("Unknown format code for uint : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case UINT_CODE:
                this.value = TypeRegistry.instance().encoder().readUInt(in);
                break;
            case UINT_SMALLUINT_CODE:
                this.value = TypeRegistry.instance().encoder().readUIntSmallUInt(in);
                break;
            case UINT_UINT0_CODE:
                this.value = TypeRegistry.instance().encoder().readUIntUInt0(in);
                break;
            default:
                throw new Exception(("Unknown format code for uint : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return UINT_CODE;
    }

}
