
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPULong
    implements AMQPType
{

    protected BigInteger value;
    public final static byte ULONG_CODE = ((byte)0x80);
    public final static int ULONG_WIDTH = 8;
    public final static byte ULONG_SMALLULONG_CODE = ((byte)0x53);
    public final static int ULONG_SMALLULONG_WIDTH = 1;
    public final static byte ULONG_ULONG0_CODE = ((byte)0x44);
    public final static int ULONG_ULONG0_WIDTH = 0;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(ULONG_CODE, AMQPULong.class);
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(ULONG_SMALLULONG_CODE, AMQPULong.class);
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(ULONG_ULONG0_CODE, AMQPULong.class);
    }

    public AMQPULong() {
        this.value = null;
    }

    public AMQPULong(BigInteger value) {
        this.value = value;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfULong(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPULong))) {
            return false;
        }
        return this.equals(((AMQPULong) other));
    }

    public boolean equals(AMQPULong other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPULong.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPULong.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPULong.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPULong.writeBody(formatCode, this.value, out);
    }

    public static void write(BigInteger value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPULong.writeConstructor(value, out);
        AMQPULong.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(BigInteger value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseULongEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, BigInteger value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case ULONG_CODE:
                TypeRegistry.instance().encoder().writeULong(value, out);
                break;
            case ULONG_SMALLULONG_CODE:
                TypeRegistry.instance().encoder().writeULongSmallULong(value, out);
                break;
            case ULONG_ULONG0_CODE:
                TypeRegistry.instance().encoder().writeULongULong0(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for ulong : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static BigInteger read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((BigInteger) TypeRegistry.instance().encoder().readNull(in));
            case ULONG_CODE:
                return TypeRegistry.instance().encoder().readULong(in);
            case ULONG_SMALLULONG_CODE:
                return TypeRegistry.instance().encoder().readULongSmallULong(in);
            case ULONG_ULONG0_CODE:
                return TypeRegistry.instance().encoder().readULongULong0(in);
            default:
                throw new Exception(("Unknown format code for ulong : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case ULONG_CODE:
                this.value = TypeRegistry.instance().encoder().readULong(in);
                break;
            case ULONG_SMALLULONG_CODE:
                this.value = TypeRegistry.instance().encoder().readULongSmallULong(in);
                break;
            case ULONG_ULONG0_CODE:
                this.value = TypeRegistry.instance().encoder().readULongULong0(in);
                break;
            default:
                throw new Exception(("Unknown format code for ulong : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return ULONG_CODE;
    }

}
