
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPUShort
    implements AMQPType
{

    protected Integer value;
    public final static byte USHORT_CODE = ((byte)0x60);
    public final static int USHORT_WIDTH = 2;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(USHORT_CODE, AMQPUShort.class);
    }

    public AMQPUShort() {
        this.value = null;
    }

    public AMQPUShort(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfUShort(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPUShort))) {
            return false;
        }
        return this.equals(((AMQPUShort) other));
    }

    public boolean equals(AMQPUShort other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPUShort.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPUShort.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPUShort.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPUShort.writeBody(formatCode, this.value, out);
    }

    public static void write(Integer value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPUShort.writeConstructor(value, out);
        AMQPUShort.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(Integer value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseUShortEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, Integer value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case USHORT_CODE:
                TypeRegistry.instance().encoder().writeUShort(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for ushort : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static Integer read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((Integer) TypeRegistry.instance().encoder().readNull(in));
            case USHORT_CODE:
                return TypeRegistry.instance().encoder().readUShort(in);
            default:
                throw new Exception(("Unknown format code for ushort : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case USHORT_CODE:
                this.value = TypeRegistry.instance().encoder().readUShort(in);
                break;
            default:
                throw new Exception(("Unknown format code for ushort : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return USHORT_CODE;
    }

}
