
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.UUID;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;

public class AMQPUUID
    implements AMQPType
{

    protected UUID value;
    public final static byte UUID_CODE = ((byte)0x98);
    public final static int UUID_WIDTH = 16;

    static {
        TypeRegistry.instance().getPrimitiveFormatCodeMap().put(UUID_CODE, AMQPUUID.class);
    }

    public AMQPUUID() {
        this.value = null;
    }

    public AMQPUUID(UUID value) {
        this.value = value;
    }

    public UUID getValue() {
        return this.value;
    }

    public void setValue(UUID value) {
        this.value = value;
    }

    public long size() {
        return TypeRegistry.instance().sizer().sizeOfUUID(value);
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        if ((other == null)||(!(other instanceof AMQPUUID))) {
            return false;
        }
        return this.equals(((AMQPUUID) other));
    }

    public boolean equals(AMQPUUID other) {
        if (other == null) {
            return false;
        }
        if ((this.value == null)&&(other.getValue()!= null)) {
            return false;
        } else {
            if ((this.value!= null)&&(other.getValue() == null)) {
                return false;
            } else {
                if ((this.value == null)&&(other.getValue() == null)) {
                    return true;
                } else {
                    return this.value.equals(other.getValue());
                }
            }
        }
    }

    public int hashCode() {
        if (this.value == null) {
            return AMQPUUID.class.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public long sizeOfConstructor() {
        return  1;
    }

    public long sizeOfBody() {
        return (size()-sizeOfConstructor());
    }

    public void write(DataOutput out)
        throws Exception
    {
        AMQPUUID.write(this.value, out);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        return AMQPUUID.writeConstructor(this.value, out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        AMQPUUID.writeBody(formatCode, this.value, out);
    }

    public static void write(UUID value, DataOutput out)
        throws Exception
    {
        byte formatCode = AMQPUUID.writeConstructor(value, out);
        AMQPUUID.writeBody(formatCode, value, out);
    }

    public static byte writeConstructor(UUID value, DataOutput out)
        throws Exception
    {
        byte formatCode = TypeRegistry.instance().picker().chooseUUIDEncoding(value);
        out.writeByte(formatCode);
        return formatCode;
    }

    public static void writeBody(byte formatCode, UUID value, DataOutput out)
        throws Exception
    {
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                break;
            case UUID_CODE:
                TypeRegistry.instance().encoder().writeUUID(value, out);
                break;
            default:
                throw new Exception(("Unknown format code for uuid : 0x"+ String.format("%x", formatCode)));
        }
    }

    public static UUID read(DataInput in)
        throws Exception
    {
        byte formatCode = in.readByte();
        switch (formatCode) {
            case TypeRegistry.NULL_FORMAT_CODE:
                return ((UUID) TypeRegistry.instance().encoder().readNull(in));
            case UUID_CODE:
                return TypeRegistry.instance().encoder().readUUID(in);
            default:
                throw new Exception(("Unknown format code for uuid : 0x"+ String.format("%x", formatCode)));
        }
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        switch (formatCode) {
            case UUID_CODE:
                this.value = TypeRegistry.instance().encoder().readUUID(in);
                break;
            default:
                throw new Exception(("Unknown format code for uuid : 0x"+ String.format("%x", formatCode)));
        }
    }

    public Object getArrayConstructor() {
        return UUID_CODE;
    }

}
