
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import java.util.Arrays;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class Attach
    implements AMQPFrame
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:attach:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000012", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * name:string
     * 
     */
    protected String name;
    /**
     * handle:handle
     * 
     */
    protected Long handle;
    /**
     * role:role
     * 
     */
    protected Boolean role;
    /**
     * snd-settle-mode:sender-settle-mode
     * 
     */
    protected Short snd_settle_mode;
    /**
     * rcv-settle-mode:receiver-settle-mode
     * 
     */
    protected Short rcv_settle_mode;
    /**
     * source:*
     * 
     */
    protected org.fusesource.amqp.types.AMQPType source;
    /**
     * target:*
     * 
     */
    protected org.fusesource.amqp.types.AMQPType target;
    /**
     * unsettled:map
     * 
     */
    protected org.fusesource.amqp.types.MapEntries unsettled;
    /**
     * incomplete-unsettled:boolean
     * 
     */
    protected Boolean incomplete_unsettled;
    /**
     * initial-delivery-count:sequence-no
     * 
     */
    protected Long initial_delivery_count;
    /**
     * max-message-size:ulong
     * 
     */
    protected BigInteger max_message_size;
    /**
     * offered-capabilities:symbol
     * 
     */
    protected org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities;
    /**
     * desired-capabilities:symbol
     * 
     */
    protected org.fusesource.amqp.types.AMQPSymbol[] desired_capabilities;
    /**
     * properties:fields
     * 
     */
    protected org.fusesource.amqp.types.MapEntries properties;
    public final static Boolean INCOMPLETE_UNSETTLED_DEFAULT = false;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, Attach.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, Attach.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public Attach() {
    }

    public Attach(String name) {
        this.name = name;
    }

    public Attach(String name, Long handle) {
        this.name = name;
        this.handle = handle;
    }

    public Attach(String name, Long handle, Boolean role) {
        this.name = name;
        this.handle = handle;
        this.role = role;
    }

    public Attach(String name, Long handle, Boolean role, Short snd_settle_mode) {
        this.name = name;
        this.handle = handle;
        this.role = role;
        this.snd_settle_mode = snd_settle_mode;
    }

    public Attach(String name, Long handle, Boolean role, Short snd_settle_mode, Short rcv_settle_mode) {
        this.name = name;
        this.handle = handle;
        this.role = role;
        this.snd_settle_mode = snd_settle_mode;
        this.rcv_settle_mode = rcv_settle_mode;
    }

    public Attach(String name, Long handle, Boolean role, Short snd_settle_mode, Short rcv_settle_mode, org.fusesource.amqp.types.AMQPType source) {
        this.name = name;
        this.handle = handle;
        this.role = role;
        this.snd_settle_mode = snd_settle_mode;
        this.rcv_settle_mode = rcv_settle_mode;
        this.source = source;
    }

    public Attach(String name, Long handle, Boolean role, Short snd_settle_mode, Short rcv_settle_mode, org.fusesource.amqp.types.AMQPType source, org.fusesource.amqp.types.AMQPType target) {
        this.name = name;
        this.handle = handle;
        this.role = role;
        this.snd_settle_mode = snd_settle_mode;
        this.rcv_settle_mode = rcv_settle_mode;
        this.source = source;
        this.target = target;
    }

    public Attach(String name, Long handle, Boolean role, Short snd_settle_mode, Short rcv_settle_mode, org.fusesource.amqp.types.AMQPType source, org.fusesource.amqp.types.AMQPType target, org.fusesource.amqp.types.MapEntries unsettled) {
        this.name = name;
        this.handle = handle;
        this.role = role;
        this.snd_settle_mode = snd_settle_mode;
        this.rcv_settle_mode = rcv_settle_mode;
        this.source = source;
        this.target = target;
        this.unsettled = unsettled;
    }

    public Attach(String name, Long handle, Boolean role, Short snd_settle_mode, Short rcv_settle_mode, org.fusesource.amqp.types.AMQPType source, org.fusesource.amqp.types.AMQPType target, org.fusesource.amqp.types.MapEntries unsettled, Boolean incomplete_unsettled) {
        this.name = name;
        this.handle = handle;
        this.role = role;
        this.snd_settle_mode = snd_settle_mode;
        this.rcv_settle_mode = rcv_settle_mode;
        this.source = source;
        this.target = target;
        this.unsettled = unsettled;
        this.incomplete_unsettled = incomplete_unsettled;
    }

    public Attach(String name, Long handle, Boolean role, Short snd_settle_mode, Short rcv_settle_mode, org.fusesource.amqp.types.AMQPType source, org.fusesource.amqp.types.AMQPType target, org.fusesource.amqp.types.MapEntries unsettled, Boolean incomplete_unsettled, Long initial_delivery_count) {
        this.name = name;
        this.handle = handle;
        this.role = role;
        this.snd_settle_mode = snd_settle_mode;
        this.rcv_settle_mode = rcv_settle_mode;
        this.source = source;
        this.target = target;
        this.unsettled = unsettled;
        this.incomplete_unsettled = incomplete_unsettled;
        this.initial_delivery_count = initial_delivery_count;
    }

    public Attach(String name, Long handle, Boolean role, Short snd_settle_mode, Short rcv_settle_mode, org.fusesource.amqp.types.AMQPType source, org.fusesource.amqp.types.AMQPType target, org.fusesource.amqp.types.MapEntries unsettled, Boolean incomplete_unsettled, Long initial_delivery_count, BigInteger max_message_size) {
        this.name = name;
        this.handle = handle;
        this.role = role;
        this.snd_settle_mode = snd_settle_mode;
        this.rcv_settle_mode = rcv_settle_mode;
        this.source = source;
        this.target = target;
        this.unsettled = unsettled;
        this.incomplete_unsettled = incomplete_unsettled;
        this.initial_delivery_count = initial_delivery_count;
        this.max_message_size = max_message_size;
    }

    public Attach(String name, Long handle, Boolean role, Short snd_settle_mode, Short rcv_settle_mode, org.fusesource.amqp.types.AMQPType source, org.fusesource.amqp.types.AMQPType target, org.fusesource.amqp.types.MapEntries unsettled, Boolean incomplete_unsettled, Long initial_delivery_count, BigInteger max_message_size, org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities) {
        this.name = name;
        this.handle = handle;
        this.role = role;
        this.snd_settle_mode = snd_settle_mode;
        this.rcv_settle_mode = rcv_settle_mode;
        this.source = source;
        this.target = target;
        this.unsettled = unsettled;
        this.incomplete_unsettled = incomplete_unsettled;
        this.initial_delivery_count = initial_delivery_count;
        this.max_message_size = max_message_size;
        this.offered_capabilities = offered_capabilities;
    }

    public Attach(String name, Long handle, Boolean role, Short snd_settle_mode, Short rcv_settle_mode, org.fusesource.amqp.types.AMQPType source, org.fusesource.amqp.types.AMQPType target, org.fusesource.amqp.types.MapEntries unsettled, Boolean incomplete_unsettled, Long initial_delivery_count, BigInteger max_message_size, org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities, org.fusesource.amqp.types.AMQPSymbol[] desired_capabilities) {
        this.name = name;
        this.handle = handle;
        this.role = role;
        this.snd_settle_mode = snd_settle_mode;
        this.rcv_settle_mode = rcv_settle_mode;
        this.source = source;
        this.target = target;
        this.unsettled = unsettled;
        this.incomplete_unsettled = incomplete_unsettled;
        this.initial_delivery_count = initial_delivery_count;
        this.max_message_size = max_message_size;
        this.offered_capabilities = offered_capabilities;
        this.desired_capabilities = desired_capabilities;
    }

    public Attach(String name, Long handle, Boolean role, Short snd_settle_mode, Short rcv_settle_mode, org.fusesource.amqp.types.AMQPType source, org.fusesource.amqp.types.AMQPType target, org.fusesource.amqp.types.MapEntries unsettled, Boolean incomplete_unsettled, Long initial_delivery_count, BigInteger max_message_size, org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities, org.fusesource.amqp.types.AMQPSymbol[] desired_capabilities, org.fusesource.amqp.types.MapEntries properties) {
        this.name = name;
        this.handle = handle;
        this.role = role;
        this.snd_settle_mode = snd_settle_mode;
        this.rcv_settle_mode = rcv_settle_mode;
        this.source = source;
        this.target = target;
        this.unsettled = unsettled;
        this.incomplete_unsettled = incomplete_unsettled;
        this.initial_delivery_count = initial_delivery_count;
        this.max_message_size = max_message_size;
        this.offered_capabilities = offered_capabilities;
        this.desired_capabilities = desired_capabilities;
        this.properties = properties;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getHandle() {
        return this.handle;
    }

    public void setHandle(Long handle) {
        this.handle = handle;
    }

    public Boolean getRole() {
        return this.role;
    }

    public void setRole(Boolean role) {
        this.role = role;
    }

    public Short getSndSettleMode() {
        return this.snd_settle_mode;
    }

    public void setSndSettleMode(Short snd_settle_mode) {
        this.snd_settle_mode = snd_settle_mode;
    }

    public Short getRcvSettleMode() {
        return this.rcv_settle_mode;
    }

    public void setRcvSettleMode(Short rcv_settle_mode) {
        this.rcv_settle_mode = rcv_settle_mode;
    }

    public org.fusesource.amqp.types.AMQPType getSource() {
        return this.source;
    }

    public void setSource(org.fusesource.amqp.types.AMQPType source) {
        this.source = source;
    }

    public org.fusesource.amqp.types.AMQPType getTarget() {
        return this.target;
    }

    public void setTarget(org.fusesource.amqp.types.AMQPType target) {
        this.target = target;
    }

    public org.fusesource.amqp.types.MapEntries getUnsettled() {
        return this.unsettled;
    }

    public void setUnsettled(org.fusesource.amqp.types.MapEntries unsettled) {
        this.unsettled = unsettled;
    }

    public Boolean getIncompleteUnsettled() {
        return this.incomplete_unsettled;
    }

    public void setIncompleteUnsettled(Boolean incomplete_unsettled) {
        this.incomplete_unsettled = incomplete_unsettled;
    }

    public Long getInitialDeliveryCount() {
        return this.initial_delivery_count;
    }

    public void setInitialDeliveryCount(Long initial_delivery_count) {
        this.initial_delivery_count = initial_delivery_count;
    }

    public BigInteger getMaxMessageSize() {
        return this.max_message_size;
    }

    public void setMaxMessageSize(BigInteger max_message_size) {
        this.max_message_size = max_message_size;
    }

    public org.fusesource.amqp.types.AMQPSymbol[] getOfferedCapabilities() {
        return this.offered_capabilities;
    }

    public void setOfferedCapabilities(org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities) {
        this.offered_capabilities = offered_capabilities;
    }

    public org.fusesource.amqp.types.AMQPSymbol[] getDesiredCapabilities() {
        return this.desired_capabilities;
    }

    public void setDesiredCapabilities(org.fusesource.amqp.types.AMQPSymbol[] desired_capabilities) {
        this.desired_capabilities = desired_capabilities;
    }

    public org.fusesource.amqp.types.MapEntries getProperties() {
        return this.properties;
    }

    public void setProperties(org.fusesource.amqp.types.MapEntries properties) {
        this.properties = properties;
    }

    public int count() {
        int rc = 14;
        if (properties == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (desired_capabilities == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (offered_capabilities == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (max_message_size == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (initial_delivery_count == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (incomplete_unsettled == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (unsettled == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (target == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (source == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (rcv_settle_mode == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (snd_settle_mode == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (role == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (handle == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (name == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            name = org.fusesource.amqp.types.AMQPString.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            handle = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            role = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            snd_settle_mode = org.fusesource.amqp.types.AMQPUByte.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            rcv_settle_mode = org.fusesource.amqp.types.AMQPUByte.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            source = ((org.fusesource.amqp.types.AMQPType) org.fusesource.amqp.codec.marshaller.TypeReader.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            target = ((org.fusesource.amqp.types.AMQPType) org.fusesource.amqp.codec.marshaller.TypeReader.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            unsettled = org.fusesource.amqp.types.AMQPMap.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            incomplete_unsettled = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            initial_delivery_count = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            max_message_size = org.fusesource.amqp.types.AMQPULong.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            offered_capabilities = ((org.fusesource.amqp.types.AMQPSymbol[]) AMQPArray.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            desired_capabilities = ((org.fusesource.amqp.types.AMQPSymbol[]) AMQPArray.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            properties = org.fusesource.amqp.types.AMQPMap.read(in);
        }
        if (name == null) {
            throw new RuntimeException("No value specified for mandatory attribute name");
        }
        if (handle == null) {
            throw new RuntimeException("No value specified for mandatory attribute handle");
        }
        if (role == null) {
            throw new RuntimeException("No value specified for mandatory attribute role");
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPString.write(this.name, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.handle, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.role, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUByte.write(this.snd_settle_mode, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUByte.write(this.rcv_settle_mode, out);
        }
        count = (count- 1);
        if (count >= 0) {
            if (source!= null) {
                source.write(out);
            } else {
                out.writeByte(TypeRegistry.NULL_FORMAT_CODE);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            if (target!= null) {
                target.write(out);
            } else {
                out.writeByte(TypeRegistry.NULL_FORMAT_CODE);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPMap.write(this.unsettled, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.incomplete_unsettled, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.initial_delivery_count, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPULong.write(this.max_message_size, out);
        }
        count = (count- 1);
        if (count >= 0) {
            AMQPArray.write(this.offered_capabilities, out);
        }
        count = (count- 1);
        if (count >= 0) {
            AMQPArray.write(this.desired_capabilities, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPMap.write(this.properties, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfString(name));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(handle));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(role));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUByte(snd_settle_mode));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUByte(rcv_settle_mode));
        }
        count = (count- 1);
        if (count >= 0) {
            if (source!= null) {
                fieldSize = (fieldSize + source.size());
            } else {
                fieldSize = (fieldSize + 1L);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            if (target!= null) {
                fieldSize = (fieldSize + target.size());
            } else {
                fieldSize = (fieldSize + 1L);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfMap(unsettled));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(incomplete_unsettled));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(initial_delivery_count));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfULong(max_message_size));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfArray(offered_capabilities));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfArray(desired_capabilities));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfMap(properties));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.name!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   name:"+ this.name));
        }
        if (this.handle!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   handle:"+ this.handle));
        }
        if (this.role!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   role:"+ this.role));
        }
        if (this.snd_settle_mode!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   snd_settle_mode:"+ this.snd_settle_mode));
        }
        if (this.rcv_settle_mode!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   rcv_settle_mode:"+ this.rcv_settle_mode));
        }
        if (this.source!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   source:"+ this.source.toString((indent +"   "))));
        }
        if (this.target!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   target:"+ this.target.toString((indent +"   "))));
        }
        if (this.unsettled!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   unsettled:"+ this.unsettled));
        }
        if (this.incomplete_unsettled!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   incomplete_unsettled:"+ this.incomplete_unsettled));
        }
        if (this.initial_delivery_count!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   initial_delivery_count:"+ this.initial_delivery_count));
        }
        if (this.max_message_size!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   max_message_size:"+ this.max_message_size));
        }
        if (this.offered_capabilities!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   offered_capabilities:"+ Arrays.toString(this.offered_capabilities)));
        }
        if (this.desired_capabilities!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   desired_capabilities:"+ Arrays.toString(this.desired_capabilities)));
        }
        if (this.properties!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   properties:"+ this.properties));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[Attach"+ rc)+"]");
    }

}
