
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import java.util.Arrays;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class Begin
    implements AMQPFrame
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:begin:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000011", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * remote-channel:ushort
     * 
     */
    protected Integer remote_channel;
    /**
     * next-outgoing-id:transfer-number
     * 
     */
    protected Long next_outgoing_id;
    /**
     * incoming-window:uint
     * 
     */
    protected Long incoming_window;
    /**
     * outgoing-window:uint
     * 
     */
    protected Long outgoing_window;
    /**
     * handle-max:handle
     * 
     */
    protected Long handle_max;
    /**
     * offered-capabilities:symbol
     * 
     */
    protected org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities;
    /**
     * desired-capabilities:symbol
     * 
     */
    protected org.fusesource.amqp.types.AMQPSymbol[] desired_capabilities;
    /**
     * properties:fields
     * 
     */
    protected MapEntries properties;
    public final static Long HANDLE_MAX_DEFAULT = 4294967295L;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, Begin.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, Begin.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public Begin() {
    }

    public Begin(Integer remote_channel) {
        this.remote_channel = remote_channel;
    }

    public Begin(Integer remote_channel, Long next_outgoing_id) {
        this.remote_channel = remote_channel;
        this.next_outgoing_id = next_outgoing_id;
    }

    public Begin(Integer remote_channel, Long next_outgoing_id, Long incoming_window) {
        this.remote_channel = remote_channel;
        this.next_outgoing_id = next_outgoing_id;
        this.incoming_window = incoming_window;
    }

    public Begin(Integer remote_channel, Long next_outgoing_id, Long incoming_window, Long outgoing_window) {
        this.remote_channel = remote_channel;
        this.next_outgoing_id = next_outgoing_id;
        this.incoming_window = incoming_window;
        this.outgoing_window = outgoing_window;
    }

    public Begin(Integer remote_channel, Long next_outgoing_id, Long incoming_window, Long outgoing_window, Long handle_max) {
        this.remote_channel = remote_channel;
        this.next_outgoing_id = next_outgoing_id;
        this.incoming_window = incoming_window;
        this.outgoing_window = outgoing_window;
        this.handle_max = handle_max;
    }

    public Begin(Integer remote_channel, Long next_outgoing_id, Long incoming_window, Long outgoing_window, Long handle_max, org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities) {
        this.remote_channel = remote_channel;
        this.next_outgoing_id = next_outgoing_id;
        this.incoming_window = incoming_window;
        this.outgoing_window = outgoing_window;
        this.handle_max = handle_max;
        this.offered_capabilities = offered_capabilities;
    }

    public Begin(Integer remote_channel, Long next_outgoing_id, Long incoming_window, Long outgoing_window, Long handle_max, org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities, org.fusesource.amqp.types.AMQPSymbol[] desired_capabilities) {
        this.remote_channel = remote_channel;
        this.next_outgoing_id = next_outgoing_id;
        this.incoming_window = incoming_window;
        this.outgoing_window = outgoing_window;
        this.handle_max = handle_max;
        this.offered_capabilities = offered_capabilities;
        this.desired_capabilities = desired_capabilities;
    }

    public Begin(Integer remote_channel, Long next_outgoing_id, Long incoming_window, Long outgoing_window, Long handle_max, org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities, org.fusesource.amqp.types.AMQPSymbol[] desired_capabilities, MapEntries properties) {
        this.remote_channel = remote_channel;
        this.next_outgoing_id = next_outgoing_id;
        this.incoming_window = incoming_window;
        this.outgoing_window = outgoing_window;
        this.handle_max = handle_max;
        this.offered_capabilities = offered_capabilities;
        this.desired_capabilities = desired_capabilities;
        this.properties = properties;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public Integer getRemoteChannel() {
        return this.remote_channel;
    }

    public void setRemoteChannel(Integer remote_channel) {
        this.remote_channel = remote_channel;
    }

    public Long getNextOutgoingID() {
        return this.next_outgoing_id;
    }

    public void setNextOutgoingID(Long next_outgoing_id) {
        this.next_outgoing_id = next_outgoing_id;
    }

    public Long getIncomingWindow() {
        return this.incoming_window;
    }

    public void setIncomingWindow(Long incoming_window) {
        this.incoming_window = incoming_window;
    }

    public Long getOutgoingWindow() {
        return this.outgoing_window;
    }

    public void setOutgoingWindow(Long outgoing_window) {
        this.outgoing_window = outgoing_window;
    }

    public Long getHandleMax() {
        return this.handle_max;
    }

    public void setHandleMax(Long handle_max) {
        this.handle_max = handle_max;
    }

    public org.fusesource.amqp.types.AMQPSymbol[] getOfferedCapabilities() {
        return this.offered_capabilities;
    }

    public void setOfferedCapabilities(org.fusesource.amqp.types.AMQPSymbol[] offered_capabilities) {
        this.offered_capabilities = offered_capabilities;
    }

    public org.fusesource.amqp.types.AMQPSymbol[] getDesiredCapabilities() {
        return this.desired_capabilities;
    }

    public void setDesiredCapabilities(org.fusesource.amqp.types.AMQPSymbol[] desired_capabilities) {
        this.desired_capabilities = desired_capabilities;
    }

    public MapEntries getProperties() {
        return this.properties;
    }

    public void setProperties(MapEntries properties) {
        this.properties = properties;
    }

    public int count() {
        int rc = 8;
        if (properties == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (desired_capabilities == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (offered_capabilities == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (handle_max == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (outgoing_window == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (incoming_window == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (next_outgoing_id == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (remote_channel == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            remote_channel = org.fusesource.amqp.types.AMQPUShort.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            next_outgoing_id = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            incoming_window = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            outgoing_window = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            handle_max = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            offered_capabilities = ((org.fusesource.amqp.types.AMQPSymbol[]) AMQPArray.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            desired_capabilities = ((org.fusesource.amqp.types.AMQPSymbol[]) AMQPArray.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            properties = org.fusesource.amqp.types.AMQPMap.read(in);
        }
        if (next_outgoing_id == null) {
            throw new RuntimeException("No value specified for mandatory attribute next_outgoing_id");
        }
        if (incoming_window == null) {
            throw new RuntimeException("No value specified for mandatory attribute incoming_window");
        }
        if (outgoing_window == null) {
            throw new RuntimeException("No value specified for mandatory attribute outgoing_window");
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUShort.write(this.remote_channel, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.next_outgoing_id, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.incoming_window, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.outgoing_window, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.handle_max, out);
        }
        count = (count- 1);
        if (count >= 0) {
            AMQPArray.write(this.offered_capabilities, out);
        }
        count = (count- 1);
        if (count >= 0) {
            AMQPArray.write(this.desired_capabilities, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPMap.write(this.properties, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUShort(remote_channel));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(next_outgoing_id));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(incoming_window));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(outgoing_window));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(handle_max));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfArray(offered_capabilities));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfArray(desired_capabilities));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfMap(properties));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.remote_channel!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   remote_channel:"+ this.remote_channel));
        }
        if (this.next_outgoing_id!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   next_outgoing_id:"+ this.next_outgoing_id));
        }
        if (this.incoming_window!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   incoming_window:"+ this.incoming_window));
        }
        if (this.outgoing_window!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   outgoing_window:"+ this.outgoing_window));
        }
        if (this.handle_max!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   handle_max:"+ this.handle_max));
        }
        if (this.offered_capabilities!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   offered_capabilities:"+ Arrays.toString(this.offered_capabilities)));
        }
        if (this.desired_capabilities!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   desired_capabilities:"+ Arrays.toString(this.desired_capabilities)));
        }
        if (this.properties!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   properties:"+ this.properties));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[Begin"+ rc)+"]");
    }

}
