
package org.fusesource.amqp.types;

import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class ConnectionError
    extends AMQPSymbol
    implements AMQPErrorCondition
{

    public final static ConnectionError CONNECTION_FORCED = new ConnectionError(new AsciiBuffer("amqp:connection:forced"));
    public final static ConnectionError FRAMING_ERROR = new ConnectionError(new AsciiBuffer("amqp:connection:framing-error"));
    public final static ConnectionError REDIRECT = new ConnectionError(new AsciiBuffer("amqp:connection:redirect"));

    public ConnectionError() {
    }

    public ConnectionError(Buffer value) {
        this.value = value;
    }

    public static ConnectionError valueOf(Buffer value) {
        if (value == null) {
            return null;
        }
        if (value == CONNECTION_FORCED.getValue()) {
            return CONNECTION_FORCED;
        }
        if (value == FRAMING_ERROR.getValue()) {
            return FRAMING_ERROR;
        }
        if (value == REDIRECT.getValue()) {
            return REDIRECT;
        }
        throw new IllegalArgumentException(("invalid ConnectionError value: "+ value));
    }

}
