
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class DeleteOnClose
    implements AMQPLifetimePolicy
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:delete-on-close:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("000000000000002b", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, DeleteOnClose.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, DeleteOnClose.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public DeleteOnClose() {
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public int count() {
        int rc = 0;
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[DeleteOnClose"+ rc)+"]");
    }

}
