
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import org.fusesource.amqp.codec.marshaller.TypeReader;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class Detach
    implements AMQPFrame
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:detach:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000016", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * handle:handle
     * 
     */
    protected Long handle;
    /**
     * closed:boolean
     * 
     */
    protected Boolean closed;
    /**
     * error:error
     * 
     */
    protected Error error;
    public final static Boolean CLOSED_DEFAULT = false;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, Detach.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, Detach.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public Detach() {
    }

    public Detach(Long handle) {
        this.handle = handle;
    }

    public Detach(Long handle, Boolean closed) {
        this.handle = handle;
        this.closed = closed;
    }

    public Detach(Long handle, Boolean closed, Error error) {
        this.handle = handle;
        this.closed = closed;
        this.error = error;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public Long getHandle() {
        return this.handle;
    }

    public void setHandle(Long handle) {
        this.handle = handle;
    }

    public Boolean getClosed() {
        return this.closed;
    }

    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    public Error getError() {
        return this.error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public int count() {
        int rc = 3;
        if (error == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (closed == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (handle == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            handle = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            closed = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            error = ((Error) TypeReader.read(in));
        }
        if (handle == null) {
            throw new RuntimeException("No value specified for mandatory attribute handle");
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.handle, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.closed, out);
        }
        count = (count- 1);
        if (count >= 0) {
            if (error!= null) {
                error.write(out);
            } else {
                out.writeByte(TypeRegistry.NULL_FORMAT_CODE);
            }
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(handle));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(closed));
        }
        count = (count- 1);
        if (count >= 0) {
            if (error!= null) {
                fieldSize = (fieldSize + error.size());
            } else {
                fieldSize = (fieldSize + 1L);
            }
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.handle!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   handle:"+ this.handle));
        }
        if (this.closed!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   closed:"+ this.closed));
        }
        if (this.error!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   error:"+ this.error.toString((indent +"   "))));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[Detach"+ rc)+"]");
    }

}
