
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import org.fusesource.amqp.codec.marshaller.TypeReader;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class Disposition
    implements AMQPFrame
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:disposition:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000015", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * role:role
     * 
     */
    protected Boolean role;
    /**
     * first:delivery-number
     * 
     */
    protected Long first;
    /**
     * last:delivery-number
     * 
     */
    protected Long last;
    /**
     * settled:boolean
     * 
     */
    protected Boolean settled;
    /**
     * state:*
     * 
     */
    protected AMQPType state;
    /**
     * batchable:boolean
     * 
     */
    protected Boolean batchable;
    public final static Boolean SETTLED_DEFAULT = false;
    public final static Boolean BATCHABLE_DEFAULT = false;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, Disposition.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, Disposition.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public Disposition() {
    }

    public Disposition(Boolean role) {
        this.role = role;
    }

    public Disposition(Boolean role, Long first) {
        this.role = role;
        this.first = first;
    }

    public Disposition(Boolean role, Long first, Long last) {
        this.role = role;
        this.first = first;
        this.last = last;
    }

    public Disposition(Boolean role, Long first, Long last, Boolean settled) {
        this.role = role;
        this.first = first;
        this.last = last;
        this.settled = settled;
    }

    public Disposition(Boolean role, Long first, Long last, Boolean settled, AMQPType state) {
        this.role = role;
        this.first = first;
        this.last = last;
        this.settled = settled;
        this.state = state;
    }

    public Disposition(Boolean role, Long first, Long last, Boolean settled, AMQPType state, Boolean batchable) {
        this.role = role;
        this.first = first;
        this.last = last;
        this.settled = settled;
        this.state = state;
        this.batchable = batchable;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public Boolean getRole() {
        return this.role;
    }

    public void setRole(Boolean role) {
        this.role = role;
    }

    public Long getFirst() {
        return this.first;
    }

    public void setFirst(Long first) {
        this.first = first;
    }

    public Long getLast() {
        return this.last;
    }

    public void setLast(Long last) {
        this.last = last;
    }

    public Boolean getSettled() {
        return this.settled;
    }

    public void setSettled(Boolean settled) {
        this.settled = settled;
    }

    public AMQPType getState() {
        return this.state;
    }

    public void setState(AMQPType state) {
        this.state = state;
    }

    public Boolean getBatchable() {
        return this.batchable;
    }

    public void setBatchable(Boolean batchable) {
        this.batchable = batchable;
    }

    public int count() {
        int rc = 6;
        if (batchable == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (state == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (settled == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (last == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (first == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (role == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            role = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            first = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            last = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            settled = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            state = ((AMQPType) TypeReader.read(in));
        }
        count = (count- 1);
        if (count >= 0) {
            batchable = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        if (role == null) {
            throw new RuntimeException("No value specified for mandatory attribute role");
        }
        if (first == null) {
            throw new RuntimeException("No value specified for mandatory attribute first");
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.role, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.first, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.last, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.settled, out);
        }
        count = (count- 1);
        if (count >= 0) {
            if (state!= null) {
                state.write(out);
            } else {
                out.writeByte(TypeRegistry.NULL_FORMAT_CODE);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.batchable, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(role));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(first));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(last));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(settled));
        }
        count = (count- 1);
        if (count >= 0) {
            if (state!= null) {
                fieldSize = (fieldSize + state.size());
            } else {
                fieldSize = (fieldSize + 1L);
            }
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(batchable));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.role!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   role:"+ this.role));
        }
        if (this.first!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   first:"+ this.first));
        }
        if (this.last!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   last:"+ this.last));
        }
        if (this.settled!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   settled:"+ this.settled));
        }
        if (this.state!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   state:"+ this.state.toString((indent +"   "))));
        }
        if (this.batchable!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   batchable:"+ this.batchable));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[Disposition"+ rc)+"]");
    }

}
