
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class Error
    implements AMQPType
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:error:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("000000000000001d", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * condition:symbol
     * 
     */
    protected Buffer condition;
    /**
     * description:string
     * 
     */
    protected String description;
    /**
     * info:fields
     * 
     */
    protected MapEntries info;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, Error.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, Error.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public Error() {
    }

    public Error(Buffer condition) {
        this.condition = condition;
    }

    public Error(Buffer condition, String description) {
        this.condition = condition;
        this.description = description;
    }

    public Error(Buffer condition, String description, MapEntries info) {
        this.condition = condition;
        this.description = description;
        this.info = info;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public Buffer getCondition() {
        return this.condition;
    }

    public void setCondition(Buffer condition) {
        this.condition = condition;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MapEntries getInfo() {
        return this.info;
    }

    public void setInfo(MapEntries info) {
        this.info = info;
    }

    public int count() {
        int rc = 3;
        if (info == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (description == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (condition == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            condition = org.fusesource.amqp.types.AMQPSymbol.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            description = org.fusesource.amqp.types.AMQPString.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            info = org.fusesource.amqp.types.AMQPMap.read(in);
        }
        if (condition == null) {
            throw new RuntimeException("No value specified for mandatory attribute condition");
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPSymbol.write(this.condition, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPString.write(this.description, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPMap.write(this.info, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfSymbol(condition));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfString(description));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfMap(info));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.condition!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   condition:"+ this.condition));
        }
        if (this.description!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   description:"+ this.description));
        }
        if (this.info!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   info:"+ this.info));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[Error"+ rc)+"]");
    }

}
