
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class Flow
    implements AMQPFrame
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:flow:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000013", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * next-incoming-id:transfer-number
     * 
     */
    protected Long next_incoming_id;
    /**
     * incoming-window:uint
     * 
     */
    protected Long incoming_window;
    /**
     * next-outgoing-id:transfer-number
     * 
     */
    protected Long next_outgoing_id;
    /**
     * outgoing-window:uint
     * 
     */
    protected Long outgoing_window;
    /**
     * handle:handle
     * 
     */
    protected Long handle;
    /**
     * delivery-count:sequence-no
     * 
     */
    protected Long delivery_count;
    /**
     * link-credit:uint
     * 
     */
    protected Long link_credit;
    /**
     * available:uint
     * 
     */
    protected Long available;
    /**
     * drain:boolean
     * 
     */
    protected Boolean drain;
    /**
     * echo:boolean
     * 
     */
    protected Boolean echo;
    /**
     * properties:fields
     * 
     */
    protected MapEntries properties;
    public final static Boolean DRAIN_DEFAULT = false;
    public final static Boolean ECHO_DEFAULT = false;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, Flow.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, Flow.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public Flow() {
    }

    public Flow(Long next_incoming_id) {
        this.next_incoming_id = next_incoming_id;
    }

    public Flow(Long next_incoming_id, Long incoming_window) {
        this.next_incoming_id = next_incoming_id;
        this.incoming_window = incoming_window;
    }

    public Flow(Long next_incoming_id, Long incoming_window, Long next_outgoing_id) {
        this.next_incoming_id = next_incoming_id;
        this.incoming_window = incoming_window;
        this.next_outgoing_id = next_outgoing_id;
    }

    public Flow(Long next_incoming_id, Long incoming_window, Long next_outgoing_id, Long outgoing_window) {
        this.next_incoming_id = next_incoming_id;
        this.incoming_window = incoming_window;
        this.next_outgoing_id = next_outgoing_id;
        this.outgoing_window = outgoing_window;
    }

    public Flow(Long next_incoming_id, Long incoming_window, Long next_outgoing_id, Long outgoing_window, Long handle) {
        this.next_incoming_id = next_incoming_id;
        this.incoming_window = incoming_window;
        this.next_outgoing_id = next_outgoing_id;
        this.outgoing_window = outgoing_window;
        this.handle = handle;
    }

    public Flow(Long next_incoming_id, Long incoming_window, Long next_outgoing_id, Long outgoing_window, Long handle, Long delivery_count) {
        this.next_incoming_id = next_incoming_id;
        this.incoming_window = incoming_window;
        this.next_outgoing_id = next_outgoing_id;
        this.outgoing_window = outgoing_window;
        this.handle = handle;
        this.delivery_count = delivery_count;
    }

    public Flow(Long next_incoming_id, Long incoming_window, Long next_outgoing_id, Long outgoing_window, Long handle, Long delivery_count, Long link_credit) {
        this.next_incoming_id = next_incoming_id;
        this.incoming_window = incoming_window;
        this.next_outgoing_id = next_outgoing_id;
        this.outgoing_window = outgoing_window;
        this.handle = handle;
        this.delivery_count = delivery_count;
        this.link_credit = link_credit;
    }

    public Flow(Long next_incoming_id, Long incoming_window, Long next_outgoing_id, Long outgoing_window, Long handle, Long delivery_count, Long link_credit, Long available) {
        this.next_incoming_id = next_incoming_id;
        this.incoming_window = incoming_window;
        this.next_outgoing_id = next_outgoing_id;
        this.outgoing_window = outgoing_window;
        this.handle = handle;
        this.delivery_count = delivery_count;
        this.link_credit = link_credit;
        this.available = available;
    }

    public Flow(Long next_incoming_id, Long incoming_window, Long next_outgoing_id, Long outgoing_window, Long handle, Long delivery_count, Long link_credit, Long available, Boolean drain) {
        this.next_incoming_id = next_incoming_id;
        this.incoming_window = incoming_window;
        this.next_outgoing_id = next_outgoing_id;
        this.outgoing_window = outgoing_window;
        this.handle = handle;
        this.delivery_count = delivery_count;
        this.link_credit = link_credit;
        this.available = available;
        this.drain = drain;
    }

    public Flow(Long next_incoming_id, Long incoming_window, Long next_outgoing_id, Long outgoing_window, Long handle, Long delivery_count, Long link_credit, Long available, Boolean drain, Boolean echo) {
        this.next_incoming_id = next_incoming_id;
        this.incoming_window = incoming_window;
        this.next_outgoing_id = next_outgoing_id;
        this.outgoing_window = outgoing_window;
        this.handle = handle;
        this.delivery_count = delivery_count;
        this.link_credit = link_credit;
        this.available = available;
        this.drain = drain;
        this.echo = echo;
    }

    public Flow(Long next_incoming_id, Long incoming_window, Long next_outgoing_id, Long outgoing_window, Long handle, Long delivery_count, Long link_credit, Long available, Boolean drain, Boolean echo, MapEntries properties) {
        this.next_incoming_id = next_incoming_id;
        this.incoming_window = incoming_window;
        this.next_outgoing_id = next_outgoing_id;
        this.outgoing_window = outgoing_window;
        this.handle = handle;
        this.delivery_count = delivery_count;
        this.link_credit = link_credit;
        this.available = available;
        this.drain = drain;
        this.echo = echo;
        this.properties = properties;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public Long getNextIncomingID() {
        return this.next_incoming_id;
    }

    public void setNextIncomingID(Long next_incoming_id) {
        this.next_incoming_id = next_incoming_id;
    }

    public Long getIncomingWindow() {
        return this.incoming_window;
    }

    public void setIncomingWindow(Long incoming_window) {
        this.incoming_window = incoming_window;
    }

    public Long getNextOutgoingID() {
        return this.next_outgoing_id;
    }

    public void setNextOutgoingID(Long next_outgoing_id) {
        this.next_outgoing_id = next_outgoing_id;
    }

    public Long getOutgoingWindow() {
        return this.outgoing_window;
    }

    public void setOutgoingWindow(Long outgoing_window) {
        this.outgoing_window = outgoing_window;
    }

    public Long getHandle() {
        return this.handle;
    }

    public void setHandle(Long handle) {
        this.handle = handle;
    }

    public Long getDeliveryCount() {
        return this.delivery_count;
    }

    public void setDeliveryCount(Long delivery_count) {
        this.delivery_count = delivery_count;
    }

    public Long getLinkCredit() {
        return this.link_credit;
    }

    public void setLinkCredit(Long link_credit) {
        this.link_credit = link_credit;
    }

    public Long getAvailable() {
        return this.available;
    }

    public void setAvailable(Long available) {
        this.available = available;
    }

    public Boolean getDrain() {
        return this.drain;
    }

    public void setDrain(Boolean drain) {
        this.drain = drain;
    }

    public Boolean getEcho() {
        return this.echo;
    }

    public void setEcho(Boolean echo) {
        this.echo = echo;
    }

    public MapEntries getProperties() {
        return this.properties;
    }

    public void setProperties(MapEntries properties) {
        this.properties = properties;
    }

    public int count() {
        int rc = 11;
        if (properties == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (echo == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (drain == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (available == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (link_credit == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (delivery_count == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (handle == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (outgoing_window == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (next_outgoing_id == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (incoming_window == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (next_incoming_id == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            next_incoming_id = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            incoming_window = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            next_outgoing_id = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            outgoing_window = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            handle = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            delivery_count = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            link_credit = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            available = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            drain = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            echo = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            properties = org.fusesource.amqp.types.AMQPMap.read(in);
        }
        if (incoming_window == null) {
            throw new RuntimeException("No value specified for mandatory attribute incoming_window");
        }
        if (next_outgoing_id == null) {
            throw new RuntimeException("No value specified for mandatory attribute next_outgoing_id");
        }
        if (outgoing_window == null) {
            throw new RuntimeException("No value specified for mandatory attribute outgoing_window");
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.next_incoming_id, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.incoming_window, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.next_outgoing_id, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.outgoing_window, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.handle, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.delivery_count, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.link_credit, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.available, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.drain, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.echo, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPMap.write(this.properties, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(next_incoming_id));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(incoming_window));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(next_outgoing_id));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(outgoing_window));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(handle));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(delivery_count));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(link_credit));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(available));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(drain));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(echo));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfMap(properties));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.next_incoming_id!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   next_incoming_id:"+ this.next_incoming_id));
        }
        if (this.incoming_window!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   incoming_window:"+ this.incoming_window));
        }
        if (this.next_outgoing_id!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   next_outgoing_id:"+ this.next_outgoing_id));
        }
        if (this.outgoing_window!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   outgoing_window:"+ this.outgoing_window));
        }
        if (this.handle!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   handle:"+ this.handle));
        }
        if (this.delivery_count!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   delivery_count:"+ this.delivery_count));
        }
        if (this.link_credit!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   link_credit:"+ this.link_credit));
        }
        if (this.available!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   available:"+ this.available));
        }
        if (this.drain!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   drain:"+ this.drain));
        }
        if (this.echo!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   echo:"+ this.echo));
        }
        if (this.properties!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   properties:"+ this.properties));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[Flow"+ rc)+"]");
    }

}
