
package org.fusesource.amqp.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import org.fusesource.amqp.codec.marshaller.TypeRegistry;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;

public class Header
    implements AMQPSection
{

    public final static Buffer SYMBOLIC_ID = new AsciiBuffer("amqp:header:list");
    public final static Long SYMBOLIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfSymbol(SYMBOLIC_ID);
    public final static BigInteger NUMERIC_ID = new BigInteger("0000000000000070", 16);
    public final static Long NUMERIC_ID_SIZE = TypeRegistry.instance().sizer().sizeOfULong(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor SYMBOLIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(SYMBOLIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor NUMERIC_CONSTRUCTOR = new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    public final static org.fusesource.amqp.codec.marshaller.DescribedConstructor CONSTRUCTOR;
    /**
     * durable:boolean
     * 
     */
    protected Boolean durable;
    /**
     * priority:ubyte
     * 
     */
    protected Short priority;
    /**
     * ttl:milliseconds
     * 
     */
    protected Long ttl;
    /**
     * first-acquirer:boolean
     * 
     */
    protected Boolean first_acquirer;
    /**
     * delivery-count:uint
     * 
     */
    protected Long delivery_count;

    static {
        TypeRegistry.instance().getFormatCodeMap().put(NUMERIC_ID, Header.class);
        TypeRegistry.instance().getSymbolicCodeMap().put(SYMBOLIC_ID, Header.class);
        if (Boolean.parseBoolean(System.getProperty("org.fusesource.amqp.codec.UseSymbolicID"))) {
            CONSTRUCTOR = SYMBOLIC_CONSTRUCTOR;
        } else {
            CONSTRUCTOR = NUMERIC_CONSTRUCTOR;
        }
    }

    public Header() {
    }

    public Header(Boolean durable) {
        this.durable = durable;
    }

    public Header(Boolean durable, Short priority) {
        this.durable = durable;
        this.priority = priority;
    }

    public Header(Boolean durable, Short priority, Long ttl) {
        this.durable = durable;
        this.priority = priority;
        this.ttl = ttl;
    }

    public Header(Boolean durable, Short priority, Long ttl, Boolean first_acquirer) {
        this.durable = durable;
        this.priority = priority;
        this.ttl = ttl;
        this.first_acquirer = first_acquirer;
    }

    public Header(Boolean durable, Short priority, Long ttl, Boolean first_acquirer, Long delivery_count) {
        this.durable = durable;
        this.priority = priority;
        this.ttl = ttl;
        this.first_acquirer = first_acquirer;
        this.delivery_count = delivery_count;
    }

    public Object getArrayConstructor() {
        return new org.fusesource.amqp.codec.marshaller.DescribedConstructor(NUMERIC_ID);
    }

    public Boolean getDurable() {
        return this.durable;
    }

    public void setDurable(Boolean durable) {
        this.durable = durable;
    }

    public Short getPriority() {
        return this.priority;
    }

    public void setPriority(Short priority) {
        this.priority = priority;
    }

    public Long getTTL() {
        return this.ttl;
    }

    public void setTTL(Long ttl) {
        this.ttl = ttl;
    }

    public Boolean getFirstAcquirer() {
        return this.first_acquirer;
    }

    public void setFirstAcquirer(Boolean first_acquirer) {
        this.first_acquirer = first_acquirer;
    }

    public Long getDeliveryCount() {
        return this.delivery_count;
    }

    public void setDeliveryCount(Long delivery_count) {
        this.delivery_count = delivery_count;
    }

    public int count() {
        int rc = 5;
        if (delivery_count == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (first_acquirer == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (ttl == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (priority == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        if (durable == null) {
            rc = (rc- 1);
        } else {
            return rc;
        }
        return rc;
    }

    public void read(byte formatCode, DataInput in)
        throws Exception
    {
        long count = org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.readListHeader(in);
        count = (count- 1);
        if (count >= 0) {
            durable = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            priority = org.fusesource.amqp.types.AMQPUByte.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            ttl = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            first_acquirer = org.fusesource.amqp.types.AMQPBoolean.read(in);
        }
        count = (count- 1);
        if (count >= 0) {
            delivery_count = org.fusesource.amqp.types.AMQPUInt.read(in);
        }
    }

    public byte writeConstructor(DataOutput out)
        throws Exception
    {
        CONSTRUCTOR.write(out);
        return ((byte) 0);
    }

    public void write(DataOutput out)
        throws Exception
    {
        writeConstructor(out);
        writeBody(((byte) 0), out);
    }

    public void writeBody(byte formatCode, DataOutput out)
        throws Exception
    {
        long fieldSize = this.sizeOfFields();
        int count = this.count();
        org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.writeListHeader(fieldSize, count, out);
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.durable, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUByte.write(this.priority, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.ttl, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPBoolean.write(this.first_acquirer, out);
        }
        count = (count- 1);
        if (count >= 0) {
            org.fusesource.amqp.types.AMQPUInt.write(this.delivery_count, out);
        }
    }

    public long size() {
        return (sizeOfConstructor()+ sizeOfBody());
    }

    public long sizeOfConstructor() {
        return CONSTRUCTOR.size();
    }

    private long sizeOfFields() {
        long fieldSize = 0L;
        int count = this.count();
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(durable));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUByte(priority));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(ttl));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfBoolean(first_acquirer));
        }
        count = (count- 1);
        if (count >= 0) {
            fieldSize = (fieldSize + TypeRegistry.instance().sizer().sizeOfUInt(delivery_count));
        }
        return fieldSize;
    }

    public long sizeOfBody() {
        return org.fusesource.amqp.codec.marshaller.DescribedTypeSupport.fullSizeOfList(this.sizeOfFields(), this.count());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String rc = "";
        if (this.durable!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   durable:"+ this.durable));
        }
        if (this.priority!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   priority:"+ this.priority));
        }
        if (this.ttl!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   ttl:"+ this.ttl));
        }
        if (this.first_acquirer!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   first_acquirer:"+ this.first_acquirer));
        }
        if (this.delivery_count!= null) {
            if (rc.length()!= 0) {
                rc += ",\n";
            }
            rc += (indent +("   delivery_count:"+ this.delivery_count));
        }
        if (rc.length()!= 0) {
            rc = (", {\n"+(rc +"}"));
        }
        return (("[Header"+ rc)+"]");
    }

}
